/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ChangedMemberTarget
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(MemberShape.class).filter(change -> !((MemberShape)change.getOldShape()).getTarget().equals((Object)((MemberShape)change.getNewShape()).getTarget())).map(change -> this.createChangeEvent(differences, (ChangedShape<MemberShape>)change)).collect(Collectors.toList());
    }

    private ValidationEvent createChangeEvent(Differences differences, ChangedShape<MemberShape> change) {
        Shape newTarget;
        Shape oldTarget = this.getShapeTarget(differences.getOldModel(), change.getOldShape().getTarget());
        Severity severity = this.areShapesCompatible(oldTarget, newTarget = this.getShapeTarget(differences.getNewModel(), change.getNewShape().getTarget())) ? Severity.WARNING : Severity.ERROR;
        return ValidationEvent.builder().severity(severity).eventId(this.getEventId()).shape((Shape)change.getNewShape()).message(this.createMessage(change, oldTarget, newTarget)).build();
    }

    private Shape getShapeTarget(Model model, ShapeId id) {
        return model.getShape(id).orElse(null);
    }

    private boolean areShapesCompatible(Shape oldShape, Shape newShape) {
        if (oldShape == null || newShape == null) {
            return false;
        }
        return oldShape.getType() == newShape.getType() && oldShape instanceof SimpleShape && newShape instanceof SimpleShape && oldShape.getAllTraits().equals(newShape.getAllTraits());
    }

    private String createMessage(ChangedShape<MemberShape> change, Shape oldTarget, Shape newTarget) {
        return String.format("The shape targeted by the member `%s` changed from `%s`, a %s, to `%s`, a %s.", change.getShapeId(), change.getOldShape().getTarget(), oldTarget, change.getNewShape().getTarget(), newTarget);
    }
}

