/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.codegen.core.Property;
import software.amazon.smithy.utils.BuilderRef;

class TypedPropertiesBag {
    private final Map<String, Object> properties;
    private final Map<Property<?>, Object> typedProperties;

    TypedPropertiesBag(Builder<?> bagBuilder) {
        this.properties = (Map)bagBuilder.properties.copy();
        this.typedProperties = (Map)bagBuilder.typedProperties.copy();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<Property<?>, Object> getTypedProperties() {
        return this.typedProperties;
    }

    public Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public <T> Optional<T> getProperty(Property<T> property) {
        return Optional.ofNullable(this.typedProperties.get(property));
    }

    public <T> Optional<T> getProperty(String name, Class<T> type) {
        return this.getProperty(name).map(value -> {
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(String.format("%s property `%s` of `%s` is not an instance of `%s`. Found `%s`", this.getClass().getSimpleName(), name, this, type.getName(), value.getClass().getName()));
            }
            return value;
        });
    }

    public Object expectProperty(String name) {
        return this.getProperty(name).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of %s, `%s`", name, this.getClass().getSimpleName(), this)));
    }

    public <T> T expectProperty(String name, Class<T> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of %s, `%s`", name, this.getClass().getSimpleName(), this)));
    }

    public <T> T expectProperty(Property<T> property) {
        return this.getProperty(property).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` expected but not found on %s", property, this)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedPropertiesBag)) {
            return false;
        }
        return this.properties.equals(((TypedPropertiesBag)o).properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    static abstract class Builder<T extends Builder<T>> {
        BuilderRef<Map<String, Object>> properties = BuilderRef.forOrderedMap();
        BuilderRef<Map<Property<?>, Object>> typedProperties = BuilderRef.forOrderedMap();

        Builder() {
        }

        public T putProperty(String key, Object value) {
            ((Map)this.properties.get()).put(key, value);
            return (T)this;
        }

        public <K> T putProperty(Property<K> property, K value) {
            ((Map)this.typedProperties.get()).put(property, value);
            return (T)this;
        }

        public T removeProperty(String key) {
            ((Map)this.properties.get()).remove(key);
            return (T)this;
        }

        public T removeProperty(Property<?> property) {
            ((Map)this.typedProperties.get()).remove(property);
            return (T)this;
        }

        public T properties(Map<String, Object> properties) {
            this.properties.clear();
            ((Map)this.properties.get()).putAll(properties);
            return (T)this;
        }

        public T typedProperties(Map<Property<?>, Object> properties) {
            this.typedProperties.clear();
            ((Map)this.typedProperties.get()).putAll(properties);
            return (T)this;
        }
    }
}

