/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Collections;
import java.util.List;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.IntegrationTopologicalSort;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.CodeInterceptor;
import software.amazon.smithy.utils.CodeSection;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public interface SmithyIntegration<S, W extends SymbolWriter<W, ?>, C extends CodegenContext<S, W, ?>> {
    default public String name() {
        return this.getClass().getCanonicalName();
    }

    default public byte priority() {
        return 0;
    }

    default public void configure(S settings, ObjectNode integrationSettings) {
    }

    default public List<String> runBefore() {
        return Collections.emptyList();
    }

    default public List<String> runAfter() {
        return Collections.emptyList();
    }

    default public Model preprocessModel(Model model, S settings) {
        return model;
    }

    default public SymbolProvider decorateSymbolProvider(Model model, S settings, SymbolProvider symbolProvider) {
        return symbolProvider;
    }

    default public List<? extends CodeInterceptor<? extends CodeSection, W>> interceptors(C codegenContext) {
        return Collections.emptyList();
    }

    default public void customize(C codegenContext) {
    }

    public static <I extends SmithyIntegration<?, ?, ?>> List<I> sort(Iterable<I> integrations) {
        return new IntegrationTopologicalSort<I>(integrations).sort();
    }
}

