/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.writer;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.writer.CodegenWriter;
import software.amazon.smithy.codegen.core.writer.CodegenWriterFactory;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.SmithyUnstableApi;

@Deprecated
@SmithyUnstableApi
public class CodegenWriterDelegator<T extends CodegenWriter<T, ?>> {
    private final FileManifest fileManifest;
    private final SymbolProvider symbolProvider;
    private final Map<String, T> writers = new TreeMap<String, T>();
    private final CodegenWriterFactory<T> codegenWriterFactory;
    private String automaticSeparator = "\n";

    public CodegenWriterDelegator(FileManifest fileManifest, SymbolProvider symbolProvider, CodegenWriterFactory<T> codegenWriterFactory) {
        this.fileManifest = fileManifest;
        this.symbolProvider = symbolProvider;
        this.codegenWriterFactory = codegenWriterFactory;
    }

    public List<SymbolDependency> getDependencies() {
        ArrayList<SymbolDependency> resolved = new ArrayList<SymbolDependency>();
        this.writers.values().forEach(s -> resolved.addAll(s.getDependencies()));
        return resolved;
    }

    public void flushWriters() {
        for (Map.Entry<String, T> entry : this.getWriters().entrySet()) {
            this.fileManifest.writeFile(entry.getKey(), ((CodegenWriter)entry.getValue()).toString());
        }
        this.writers.clear();
    }

    public final Map<String, T> getWriters() {
        return Collections.unmodifiableMap(this.writers);
    }

    public final void useFileWriter(String filename, Consumer<T> writerConsumer) {
        this.useFileWriter(filename, "", writerConsumer);
    }

    public final void useFileWriter(String filename, String namespace, Consumer<T> writerConsumer) {
        writerConsumer.accept(this.checkoutWriter(filename, namespace));
    }

    public final void useShapeWriter(Shape shape, Consumer<T> writerConsumer) {
        Symbol symbol = this.symbolProvider.toSymbol(shape);
        T writer = this.checkoutWriter(symbol.getDefinitionFile(), symbol.getNamespace());
        ((CodegenWriter)writer).addImportReferences(symbol, SymbolReference.ContextOption.DECLARE);
        symbol.getDependencies().forEach(arg_0 -> writer.addDependency(arg_0));
        writer.pushState();
        writerConsumer.accept(writer);
        writer.popState();
    }

    public final void setAutomaticSeparator(String automaticSeparator) {
        this.automaticSeparator = Objects.requireNonNull(automaticSeparator);
    }

    private T checkoutWriter(String filename, String namespace) {
        String formattedFilename = Paths.get(filename, new String[0]).normalize().toString();
        boolean needsNewline = this.writers.containsKey(formattedFilename);
        CodegenWriter writer = this.writers.computeIfAbsent(formattedFilename, file -> this.codegenWriterFactory.apply((String)file, namespace));
        if (needsNewline) {
            writer.writeInline(this.automaticSeparator, new Object[0]);
        }
        return (T)writer;
    }
}

