/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ShapeLink
implements ToNode,
ToSmithyBuilder<ShapeLink> {
    public static final String TYPE_TEXT = "type";
    public static final String ID_TEXT = "id";
    public static final String TAGS_TEXT = "tags";
    public static final String FILE_TEXT = "file";
    public static final String LINE_TEXT = "line";
    public static final String COLUMN_TEXT = "column";
    private String type;
    private String id;
    private List<String> tags;
    private String file;
    private Integer line;
    private Integer column;

    private ShapeLink(Builder builder) {
        this.type = (String)SmithyBuilder.requiredState((String)TYPE_TEXT, (Object)builder.type);
        this.id = (String)SmithyBuilder.requiredState((String)ID_TEXT, (Object)builder.id);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
        this.file = builder.file;
        this.line = builder.line;
        this.column = builder.column;
    }

    public static ShapeLink fromNode(Node value) {
        NodeMapper mapper = new NodeMapper();
        mapper.disableFromNodeForClass(ShapeLink.class);
        return (ShapeLink)mapper.deserialize(value, ShapeLink.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ObjectNode toNode() {
        ObjectNode.Builder builder = ObjectNode.objectNodeBuilder().withMember(ID_TEXT, this.id).withMember(TYPE_TEXT, this.type).withOptionalMember(FILE_TEXT, this.getFile().map(Node::from)).withOptionalMember(LINE_TEXT, this.getLine().map(Node::from)).withOptionalMember(COLUMN_TEXT, this.getColumn().map(Node::from));
        if (!this.tags.isEmpty()) {
            builder.withMember(TAGS_TEXT, (ToNode)Node.fromStrings(this.tags));
        }
        return builder.build();
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Optional<String> getFile() {
        return Optional.ofNullable(this.file);
    }

    public Optional<Integer> getLine() {
        return Optional.ofNullable(this.line);
    }

    public Optional<Integer> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public Builder toBuilder() {
        return ShapeLink.builder().id(this.id).column(this.column).type(this.type).tags(this.tags).line(this.line).file(this.file);
    }

    public static final class Builder
    implements SmithyBuilder<ShapeLink> {
        private final List<String> tags = new ArrayList<String>();
        private String type;
        private String id;
        private String file;
        private Integer line;
        private Integer column;

        public ShapeLink build() {
            return new ShapeLink(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder line(Integer line) {
            this.line = line;
            return this;
        }

        public Builder column(Integer column) {
            this.column = column;
            return this;
        }
    }
}

