/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.SmithyIntegration;

final class IntegrationTopologicalSort<I extends SmithyIntegration<?, ?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(IntegrationTopologicalSort.class.getName());
    private final Map<String, I> integrationLookup = new LinkedHashMap<String, I>();
    private final Map<String, Integer> insertionOrder = new HashMap<String, Integer>();
    private final Map<String, Set<String>> forwardDependencies = new LinkedHashMap<String, Set<String>>();
    private final Map<String, Set<String>> reverseDependencies = new LinkedHashMap<String, Set<String>>();
    private final Queue<String> satisfied = new PriorityQueue<String>((left, right) -> {
        SmithyIntegration leftIntegration = (SmithyIntegration)this.integrationLookup.get(left);
        SmithyIntegration rightIntegration = (SmithyIntegration)this.integrationLookup.get(right);
        int byteResult = Byte.compare(rightIntegration.priority(), leftIntegration.priority());
        return byteResult == 0 ? Integer.compare(this.insertionOrder.get(left), this.insertionOrder.get(right)) : byteResult;
    });

    IntegrationTopologicalSort(Iterable<I> integrations) {
        for (SmithyIntegration integration : integrations) {
            this.addIntegration(integration);
        }
        for (SmithyIntegration integration : integrations) {
            for (String before : this.getValidatedDependencies("before", integration.name(), integration.runBefore())) {
                this.addDependency(before, integration.name());
            }
            for (String after : this.getValidatedDependencies("after", integration.name(), integration.runAfter())) {
                this.addDependency(integration.name(), after);
            }
        }
        for (SmithyIntegration integration : integrations) {
            if (this.forwardDependencies.containsKey(integration.name())) continue;
            this.satisfied.offer(integration.name());
        }
    }

    private void addIntegration(I integration) {
        SmithyIntegration previous = (SmithyIntegration)this.integrationLookup.put(integration.name(), integration);
        this.insertionOrder.put(integration.name(), this.insertionOrder.size());
        if (previous != null) {
            throw new IllegalArgumentException(String.format("Conflicting SmithyIntegration names detected for '%s': %s and %s", integration.name(), integration.getClass().getCanonicalName(), previous.getClass().getCanonicalName()));
        }
    }

    private List<String> getValidatedDependencies(String descriptor, String what, List<String> dependencies) {
        if (dependencies.isEmpty()) {
            return dependencies;
        }
        ArrayList<String> filtered = new ArrayList<String>(dependencies);
        filtered.removeIf(value -> {
            if (this.integrationLookup.containsKey(value)) {
                return false;
            }
            LOGGER.warning(what + " is supposed to run " + descriptor + " an integration that could not be found, '" + value + "'");
            return true;
        });
        return filtered;
    }

    private void addDependency(String what, String dependsOn) {
        this.forwardDependencies.computeIfAbsent(what, n -> new LinkedHashSet()).add(dependsOn);
        this.reverseDependencies.computeIfAbsent(dependsOn, n -> new LinkedHashSet()).add(what);
    }

    List<I> sort() {
        ArrayList<SmithyIntegration> result = new ArrayList<SmithyIntegration>();
        while (!this.satisfied.isEmpty()) {
            String current = this.satisfied.poll();
            this.forwardDependencies.remove(current);
            result.add((SmithyIntegration)this.integrationLookup.get(current));
            for (String dependent : this.reverseDependencies.getOrDefault(current, Collections.emptySet())) {
                Set<String> dependentDependencies = this.forwardDependencies.get(dependent);
                dependentDependencies.remove(current);
                if (!dependentDependencies.isEmpty()) continue;
                this.satisfied.offer(dependent);
            }
        }
        if (!this.forwardDependencies.isEmpty()) {
            throw new IllegalArgumentException("SmithyIntegration cycles detected among " + this.forwardDependencies.keySet());
        }
        return result;
    }
}

