/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;

public abstract class Directive<S> {
    private final Model model;
    private final S settings;
    private final ServiceShape service;
    private volatile Map<ShapeId, Shape> connectedShapes;
    private volatile Set<OperationShape> containedOperations;

    Directive(Model model, S settings, ServiceShape service) {
        this.model = model;
        this.settings = settings;
        this.service = service;
    }

    public final Model model() {
        return this.model;
    }

    public final S settings() {
        return this.settings;
    }

    public final ServiceShape service() {
        return this.service;
    }

    public final Map<ShapeId, Shape> connectedShapes() {
        Map<ShapeId, Shape> result = this.connectedShapes;
        if (result == null) {
            result = new TreeMap<ShapeId, Shape>();
            Iterator iterator = new Walker(this.model).iterateShapes((Shape)this.service);
            while (iterator.hasNext()) {
                Shape next = (Shape)iterator.next();
                result.put(next.getId(), next);
            }
            this.connectedShapes = result;
        }
        return result;
    }

    public Set<OperationShape> operations() {
        Set result = this.containedOperations;
        if (result == null) {
            result = this.containedOperations = TopDownIndex.of((Model)this.model()).getContainedOperations((ToShapeId)this.service());
        }
        return result;
    }
}

