/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.SetUtils;

public final class DependencyTracker
implements SymbolDependencyContainer {
    private static final String VERSION = "version";
    private static final String DEPENDENCIES = "dependencies";
    private static final String PACKAGE_NAME = "packageName";
    private static final String DEPENDENCY_TYPE = "dependencyType";
    private static final String PROPERTIES = "properties";
    private static final Set<String> TOP_LEVEL_PROPERTIES = SetUtils.of((Object[])new String[]{"version", "dependencies"});
    private static final Set<String> ALLOWED_SYMBOL_PROPERTIES = SetUtils.of((Object[])new String[]{"packageName", "dependencyType", "version", "properties"});
    private final List<SymbolDependency> dependencies = new ArrayList<SymbolDependency>();

    @Override
    public List<SymbolDependency> getDependencies() {
        return this.dependencies;
    }

    public SymbolDependency getByName(String name) {
        for (SymbolDependency dependency : this.dependencies) {
            if (!dependency.getPackageName().equals(name)) continue;
            return dependency;
        }
        throw new IllegalArgumentException("Unknown dependency '" + name + "'. Known dependencies: " + this.dependencies);
    }

    public SymbolDependency getByName(String name, String dependencyType) {
        for (SymbolDependency dependency : this.dependencies) {
            if (!dependency.getPackageName().equals(name) || !dependency.getDependencyType().equals(dependencyType)) continue;
            return dependency;
        }
        throw new IllegalArgumentException("Unknown dependency '" + name + "' of type '" + dependencyType + "'. Known dependencies: " + this.dependencies);
    }

    public List<SymbolDependency> getByType(String dependencyType) {
        ArrayList<SymbolDependency> result = new ArrayList<SymbolDependency>();
        for (SymbolDependency dependency : this.dependencies) {
            if (!dependency.getDependencyType().equals(dependencyType)) continue;
            result.add(dependency);
        }
        return result;
    }

    public List<SymbolDependency> getByProperty(String property) {
        ArrayList<SymbolDependency> result = new ArrayList<SymbolDependency>();
        for (SymbolDependency dependency : this.dependencies) {
            if (!dependency.getProperty(property).isPresent()) continue;
            result.add(dependency);
        }
        return result;
    }

    public List<SymbolDependency> getByProperty(String property, Object value) {
        ArrayList<SymbolDependency> result = new ArrayList<SymbolDependency>();
        for (SymbolDependency dependency : this.dependencies) {
            if (!dependency.getProperty(property).filter(p -> p.equals(value)).isPresent()) continue;
            result.add(dependency);
        }
        return result;
    }

    public void addDependency(SymbolDependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependency(String packageName, String version, String dependencyType) {
        SymbolDependency dependency = SymbolDependency.builder().packageName(packageName).version(version).dependencyType(dependencyType).build();
        this.addDependency(dependency);
    }

    public void addDependencies(SymbolDependencyContainer container) {
        for (SymbolDependency dependency : container.getDependencies()) {
            this.addDependency(dependency);
        }
    }

    public void addDependenciesFromJson(URL jsonFile) {
        Objects.requireNonNull(jsonFile, "Dependency JSON file is null, probably because the file could not be found.");
        try (InputStream stream = jsonFile.openConnection().getInputStream();){
            this.parseDependenciesFromJson(Node.parse((InputStream)stream));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error loading dependencies from " + jsonFile + ": " + e.getMessage(), e);
        }
    }

    private void parseDependenciesFromJson(Node node) {
        NodeMapper mapper = new NodeMapper();
        ObjectNode root = node.expectObjectNode();
        root.warnIfAdditionalProperties(TOP_LEVEL_PROPERTIES);
        root.expectStringMember(VERSION).expectOneOf(new String[]{"1.0"});
        for (ObjectNode value : root.expectArrayMember(DEPENDENCIES).getElementsAs(ObjectNode.class)) {
            value.warnIfAdditionalProperties(ALLOWED_SYMBOL_PROPERTIES);
            SymbolDependency.Builder builder = SymbolDependency.builder();
            builder.packageName(value.expectStringMember(PACKAGE_NAME).getValue());
            builder.version(value.expectStringMember(VERSION).getValue());
            value.getStringMember(DEPENDENCY_TYPE).ifPresent(v -> builder.dependencyType(v.getValue()));
            value.getObjectMember(PROPERTIES).ifPresent(properties -> {
                for (Map.Entry entry : properties.getStringMap().entrySet()) {
                    Object nodeAsJavaValue = mapper.deserialize((Node)entry.getValue(), Object.class);
                    builder.putProperty((String)entry.getKey(), nodeAsJavaValue);
                }
            });
            this.addDependency(builder.build());
        }
    }
}

