/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.directed;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.ShapeGenerationOrder;
import software.amazon.smithy.codegen.core.SmithyIntegration;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.codegen.core.TopologicalIndex;
import software.amazon.smithy.codegen.core.directed.CreateContextDirective;
import software.amazon.smithy.codegen.core.directed.CreateSymbolProviderDirective;
import software.amazon.smithy.codegen.core.directed.CustomizeDirective;
import software.amazon.smithy.codegen.core.directed.DirectedCodegen;
import software.amazon.smithy.codegen.core.directed.GenerateEnumDirective;
import software.amazon.smithy.codegen.core.directed.GenerateErrorDirective;
import software.amazon.smithy.codegen.core.directed.GenerateIntEnumDirective;
import software.amazon.smithy.codegen.core.directed.GenerateResourceDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.codegen.core.directed.GenerateStructureDirective;
import software.amazon.smithy.codegen.core.directed.GenerateUnionDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.SmithyBuilder;

public final class CodegenDirector<W extends SymbolWriter<W, ? extends ImportContainer>, I extends SmithyIntegration<S, W, C>, C extends CodegenContext<S, W, I>, S> {
    private static final Logger LOGGER = Logger.getLogger(CodegenDirector.class.getName());
    private Class<I> integrationClass;
    private ShapeId service;
    private Model model;
    private S settings;
    private FileManifest fileManifest;
    private Supplier<Iterable<I>> integrationFinder;
    private DirectedCodegen<C, S, I> directedCodegen;
    private final List<BiFunction<Model, ModelTransformer, Model>> transforms = new ArrayList<BiFunction<Model, ModelTransformer, Model>>();
    private ShapeGenerationOrder shapeGenerationOrder = ShapeGenerationOrder.TOPOLOGICAL;

    public static Model simplifyModelForServiceCodegen(Model model, ShapeId service, ModelTransformer transformer) {
        ServiceShape serviceShape = (ServiceShape)model.expectShape(service, ServiceShape.class);
        model = transformer.copyServiceErrorsToOperations(model, serviceShape);
        model = transformer.flattenAndRemoveMixins(model);
        return model;
    }

    public void integrationClass(Class<I> integrationClass) {
        this.integrationClass = integrationClass;
    }

    public void service(ShapeId service) {
        this.service = service;
    }

    public void directedCodegen(DirectedCodegen<C, S, I> directedCodegen) {
        this.directedCodegen = directedCodegen;
    }

    public void model(Model model) {
        this.model = model;
    }

    public void settings(S settings) {
        this.settings = settings;
    }

    public S settings(Class<S> settingsType, Node settingsNode) {
        LOGGER.fine(() -> "Loading codegen settings from node value: " + settingsNode.getSourceLocation());
        Object deserialized = new NodeMapper().deserialize(settingsNode, settingsType);
        this.settings(deserialized);
        return (S)deserialized;
    }

    public void fileManifest(FileManifest fileManifest) {
        this.fileManifest = fileManifest;
    }

    public void integrationFinder(Supplier<Iterable<I>> integrationFinder) {
        this.integrationFinder = integrationFinder;
    }

    public void integrationClassLoader(ClassLoader classLoader) {
        Objects.requireNonNull(this.integrationClass, "integrationClass() must be called before calling integrationClassLoader");
        this.integrationFinder(() -> ServiceLoader.load(this.integrationClass, classLoader));
    }

    public void performDefaultCodegenTransforms() {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Performing default codegen model transforms for directed codegen");
            return CodegenDirector.simplifyModelForServiceCodegen(model, Objects.requireNonNull(this.service), transformer);
        });
    }

    public void createDedicatedInputsAndOutputs() {
        this.createDedicatedInputsAndOutputs("Input", "Output");
    }

    public void createDedicatedInputsAndOutputs(String inputSuffix, String outputSuffix) {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Creating dedicated input and output shapes for directed codegen");
            return transformer.createDedicatedInputAndOutput(model, inputSuffix, outputSuffix);
        });
    }

    public void changeStringEnumsToEnumShapes(boolean synthesizeEnumNames) {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Creating dedicated input and output shapes for directed codegen");
            return transformer.changeStringEnumsToEnumShapes(model, synthesizeEnumNames);
        });
    }

    public void shapeGenerationOrder(ShapeGenerationOrder order) {
        this.shapeGenerationOrder = order;
    }

    public void sortMembers() {
        this.transforms.add((model, transformer) -> {
            LOGGER.finest("Sorting model members for directed codegen");
            return transformer.sortMembers(model, Shape::compareTo);
        });
    }

    public void run() {
        this.validateState();
        this.performModelTransforms();
        List<I> integrations = this.findIntegrations();
        this.preprocessModelWithIntegrations(integrations);
        ServiceShape serviceShape = (ServiceShape)this.model.expectShape(this.service, ServiceShape.class);
        SymbolProvider provider = this.createSymbolProvider(integrations, serviceShape);
        C context = this.createContext(serviceShape, provider, integrations);
        this.model = context.model();
        this.registerInterceptors(context, integrations);
        LOGGER.fine("All setup done. Beginning code generation");
        LOGGER.finest(() -> "Performing custom codegen for " + this.directedCodegen.getClass().getName() + " before shape codegen");
        CustomizeDirective customizeDirective = new CustomizeDirective(context, serviceShape);
        this.directedCodegen.customizeBeforeShapeGeneration(customizeDirective);
        LOGGER.finest(() -> "Generating shapes for service " + serviceShape.getId());
        this.generateShapesInService(context, serviceShape);
        LOGGER.finest(() -> "Generating service " + serviceShape.getId());
        this.directedCodegen.generateService(new GenerateServiceDirective(context, serviceShape));
        LOGGER.finest(() -> "Performing custom codegen for " + this.directedCodegen.getClass().getName() + " before integrations");
        this.directedCodegen.customizeBeforeIntegrations(customizeDirective);
        this.applyIntegrationCustomizations(context, integrations);
        LOGGER.finest(() -> "Performing custom codegen for " + this.directedCodegen.getClass().getName() + " after integrations");
        this.directedCodegen.customizeAfterIntegrations(customizeDirective);
        LOGGER.finest(() -> "Directed codegen finished for " + this.directedCodegen.getClass().getName());
        if (!context.writerDelegator().getWriters().isEmpty()) {
            LOGGER.info(() -> "Flushing remaining writers of " + this.directedCodegen.getClass().getName());
            context.writerDelegator().flushWriters();
        }
    }

    private void validateState() {
        SmithyBuilder.requiredState((String)"integrationClass", this.integrationClass);
        SmithyBuilder.requiredState((String)"service", (Object)this.service);
        SmithyBuilder.requiredState((String)"model", (Object)this.model);
        SmithyBuilder.requiredState((String)"settings", this.settings);
        SmithyBuilder.requiredState((String)"fileManifest", (Object)this.fileManifest);
        SmithyBuilder.requiredState((String)"directedCodegen", this.directedCodegen);
        SmithyBuilder.requiredState((String)"shapeGenerationOrder", (Object)((Object)this.shapeGenerationOrder));
        if (this.integrationFinder == null) {
            LOGGER.fine(() -> String.format("Finding %s integrations using the %s class loader", this.integrationClass.getName(), CodegenDirector.class.getCanonicalName()));
            this.integrationClassLoader(this.getClass().getClassLoader());
        }
    }

    private void performModelTransforms() {
        LOGGER.fine(() -> "Performing model transformations for " + this.directedCodegen.getClass().getName());
        ModelTransformer transformer = ModelTransformer.create();
        for (BiFunction<Model, ModelTransformer, Model> transform : this.transforms) {
            this.model = transform.apply(this.model, transformer);
        }
    }

    private List<I> findIntegrations() {
        LOGGER.fine(() -> "Finding integration implementations of " + this.integrationClass.getName());
        List<I> integrations = SmithyIntegration.sort(this.integrationFinder.get());
        integrations.forEach(i -> LOGGER.finest(() -> "Found integration " + i.getClass().getCanonicalName()));
        return integrations;
    }

    private void preprocessModelWithIntegrations(List<I> integrations) {
        LOGGER.fine(() -> "Preprocessing codegen model using " + this.integrationClass.getName());
        for (SmithyIntegration integration : integrations) {
            this.model = integration.preprocessModel(this.model, this.settings);
        }
        LOGGER.finer(() -> "Preprocessing codegen model using " + this.integrationClass.getName() + " complete");
    }

    private SymbolProvider createSymbolProvider(List<I> integrations, ServiceShape serviceShape) {
        LOGGER.fine(() -> "Creating a symbol provider from " + this.settings.getClass().getName());
        SymbolProvider provider = this.directedCodegen.createSymbolProvider(new CreateSymbolProviderDirective<S>(this.model, this.settings, serviceShape));
        LOGGER.finer(() -> "Decorating symbol provider using " + this.integrationClass.getName());
        for (SmithyIntegration integration : integrations) {
            provider = integration.decorateSymbolProvider(this.model, this.settings, provider);
        }
        return SymbolProvider.cache(provider);
    }

    private C createContext(ServiceShape serviceShape, SymbolProvider provider, List<I> integrations) {
        LOGGER.fine(() -> "Creating a codegen context for " + this.directedCodegen.getClass().getName());
        return this.directedCodegen.createContext(new CreateContextDirective<S, I>(this.model, this.settings, serviceShape, provider, this.fileManifest, integrations));
    }

    private void registerInterceptors(C context, List<I> integrations) {
        LOGGER.fine(() -> "Registering CodeInterceptors from integrations of " + this.integrationClass.getName());
        ArrayList interceptors = new ArrayList();
        for (SmithyIntegration integration : integrations) {
            interceptors.addAll(integration.interceptors(context));
        }
        context.writerDelegator().setInterceptors(interceptors);
    }

    private void generateShapesInService(C context, ServiceShape serviceShape) {
        LOGGER.fine(() -> String.format("Generating shapes for %s in %s order", this.directedCodegen.getClass().getName(), this.shapeGenerationOrder.name()));
        Set shapes = new Walker(context.model()).walkShapes((Shape)serviceShape);
        ShapeGenerator generator = new ShapeGenerator(context, serviceShape, this.directedCodegen);
        ArrayList<Shape> orderedShapes = new ArrayList<Shape>();
        switch (this.shapeGenerationOrder) {
            case ALPHABETICAL: {
                orderedShapes.addAll(shapes);
                orderedShapes.sort(Comparator.comparing(s -> s.getId().getName(serviceShape)));
                break;
            }
            case NONE: {
                orderedShapes.addAll(shapes);
                break;
            }
            default: {
                TopologicalIndex topologicalIndex = TopologicalIndex.of(context.model());
                for (Shape shape : topologicalIndex.getOrderedShapes()) {
                    if (!shapes.contains(shape)) continue;
                    orderedShapes.add(shape);
                }
                for (Shape shape : topologicalIndex.getRecursiveShapes()) {
                    if (!shapes.contains(shape)) continue;
                    orderedShapes.add(shape);
                }
            }
        }
        for (Shape shape : orderedShapes) {
            if (!shapes.contains(shape)) continue;
            shape.accept(generator);
        }
        LOGGER.finest(() -> "Finished generating shapes for " + this.directedCodegen.getClass().getName());
    }

    private void applyIntegrationCustomizations(C context, List<I> integrations) {
        for (SmithyIntegration integration : integrations) {
            LOGGER.finest(() -> "Customizing codegen for " + this.directedCodegen.getClass().getName() + " using integration " + integration.getClass().getName());
            integration.customize(context);
        }
    }

    private static class ShapeGenerator<W extends SymbolWriter<W, ? extends ImportContainer>, C extends CodegenContext<S, W, ?>, S>
    extends ShapeVisitor.Default<Void> {
        private final C context;
        private final ServiceShape serviceShape;
        private final DirectedCodegen<C, S, ?> directedCodegen;

        ShapeGenerator(C context, ServiceShape serviceShape, DirectedCodegen<C, S, ?> directedCodegen) {
            this.context = context;
            this.serviceShape = serviceShape;
            this.directedCodegen = directedCodegen;
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void resourceShape(ResourceShape shape) {
            LOGGER.finest(() -> "Generating resource " + shape.getId());
            this.directedCodegen.generateResource(new GenerateResourceDirective(this.context, this.serviceShape, shape));
            return null;
        }

        public Void structureShape(StructureShape shape) {
            if (shape.hasTrait(ErrorTrait.class)) {
                LOGGER.finest(() -> "Generating error " + shape.getId());
                this.directedCodegen.generateError(new GenerateErrorDirective(this.context, this.serviceShape, shape));
            } else {
                LOGGER.finest(() -> "Generating structure " + shape.getId());
                this.directedCodegen.generateStructure(new GenerateStructureDirective(this.context, this.serviceShape, shape));
            }
            return null;
        }

        public Void unionShape(UnionShape shape) {
            LOGGER.finest(() -> "Generating union " + shape.getId());
            this.directedCodegen.generateUnion(new GenerateUnionDirective(this.context, this.serviceShape, shape));
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(EnumTrait.class)) {
                LOGGER.finest(() -> "Generating string enum " + shape.getId());
                this.directedCodegen.generateEnumShape(new GenerateEnumDirective(this.context, this.serviceShape, (Shape)shape));
            }
            return null;
        }

        public Void enumShape(EnumShape shape) {
            LOGGER.finest(() -> "Generating enum shape" + shape.getId());
            this.directedCodegen.generateEnumShape(new GenerateEnumDirective(this.context, this.serviceShape, (Shape)shape));
            return null;
        }

        public Void intEnumShape(IntEnumShape shape) {
            LOGGER.finest(() -> "Generating intEnum shape" + shape.getId());
            this.directedCodegen.generateIntEnumShape(new GenerateIntEnumDirective(this.context, this.serviceShape, (Shape)shape));
            return null;
        }
    }
}

