/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolContainer;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.codegen.core.writer.DocWriter;
import software.amazon.smithy.codegen.core.writer.ImportContainer;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.SmithyUnstableApi;

@Deprecated
@SmithyUnstableApi
public class SymbolWriter<T extends SymbolWriter<T, U>, U extends ImportContainer>
extends AbstractCodeWriter<T>
implements SymbolDependencyContainer {
    private static final Logger LOGGER = Logger.getLogger(SymbolWriter.class.getName());
    private static final String RELATIVIZE_SYMBOLS = "__CodegenWriterRelativizeSymbols";
    private final List<SymbolDependency> dependencies = new ArrayList<SymbolDependency>();
    private final DocWriter<T> documentationWriter;
    private final U importContainer;

    public SymbolWriter(DocWriter<T> documentationWriter, U importContainer) {
        this.documentationWriter = documentationWriter;
        this.importContainer = importContainer;
        this.putFormatter('T', new DefaultSymbolFormatter());
    }

    public T setRelativizeSymbols(String relativizeSymbols) {
        this.putContext(RELATIVIZE_SYMBOLS, relativizeSymbols);
        return (T)this;
    }

    public final DocWriter<T> getDocumentationWriter() {
        return this.documentationWriter;
    }

    public final U getImportContainer() {
        return this.importContainer;
    }

    @Override
    public final List<SymbolDependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public final T addDependency(SymbolDependencyContainer dependencies) {
        List<SymbolDependency> values = dependencies.getDependencies();
        LOGGER.finest(() -> String.format("Adding dependencies from %s: %s", dependencies, values));
        this.dependencies.addAll(values);
        return (T)this;
    }

    public T addUseImports(SymbolContainer container) {
        for (Symbol symbol : container.getSymbols()) {
            this.addImport(symbol, symbol.getName(), SymbolReference.ContextOption.USE);
        }
        return (T)this;
    }

    public T addUseImports(SymbolReference symbolReference) {
        return this.addImport(symbolReference.getSymbol(), symbolReference.getAlias(), SymbolReference.ContextOption.USE);
    }

    public final T addImport(Symbol symbol, String alias, SymbolReference.ContextOption ... options) {
        LOGGER.finest(() -> String.format("Adding import %s as `%s` (%s)", symbol.getNamespace(), alias, Arrays.toString(options)));
        this.dependencies.addAll(symbol.getDependencies());
        this.importContainer.importSymbol(symbol, alias);
        this.addImportReferences(symbol, options);
        return (T)this;
    }

    final void addImportReferences(Symbol symbol, SymbolReference.ContextOption ... options) {
        block0: for (SymbolReference reference : symbol.getReferences()) {
            if (options.length == 0) {
                this.addImport(reference.getSymbol(), reference.getAlias(), options);
                continue;
            }
            for (SymbolReference.ContextOption option : options) {
                if (!reference.hasOption(option)) continue;
                this.addImport(reference.getSymbol(), reference.getAlias(), options);
                continue block0;
            }
        }
    }

    public final T writeDocs(Runnable runnable) {
        this.pushState();
        this.documentationWriter.writeDocs(this, runnable);
        this.popState();
        return (T)this;
    }

    public final T writeDocs(String docs) {
        this.writeDocs(() -> {
            SymbolWriter cfr_ignored_0 = (SymbolWriter)this.writeWithNoFormatting(docs);
        });
        return (T)this;
    }

    private final class DefaultSymbolFormatter
    implements BiFunction<Object, String, String> {
        private DefaultSymbolFormatter() {
        }

        @Override
        public String apply(Object type, String indent) {
            if (type instanceof Symbol) {
                Symbol typeSymbol = (Symbol)type;
                SymbolWriter.this.addUseImports(typeSymbol);
                String relativizeSymbols = (String)SymbolWriter.this.getContext(SymbolWriter.RELATIVIZE_SYMBOLS, String.class);
                if (relativizeSymbols != null) {
                    return typeSymbol.relativize(relativizeSymbols);
                }
                return typeSymbol.toString();
            }
            if (type instanceof SymbolReference) {
                SymbolReference typeSymbol = (SymbolReference)type;
                SymbolWriter.this.addImport(typeSymbol.getSymbol(), typeSymbol.getAlias(), SymbolReference.ContextOption.USE);
                return typeSymbol.getAlias();
            }
            throw new CodegenException("Invalid type provided to $T. Expected a Symbol or SymbolReference, but found `" + type + "`");
        }
    }
}

