/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.ImportContainer;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolContainer;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.utils.AbstractCodeWriter;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class SymbolWriter<W extends SymbolWriter<W, I>, I extends ImportContainer>
extends AbstractCodeWriter<W>
implements SymbolDependencyContainer {
    private static final Logger LOGGER = Logger.getLogger(SymbolWriter.class.getName());
    private static final String RELATIVIZE_SYMBOLS = "__RelativizeSymbols";
    private final List<SymbolDependency> dependencies = new ArrayList<SymbolDependency>();
    private final I importContainer;

    public SymbolWriter(I importContainer) {
        this.importContainer = importContainer;
        this.putFormatter('T', new DefaultSymbolFormatter());
    }

    public W setRelativizeSymbols(String relativizeSymbols) {
        this.putContext(RELATIVIZE_SYMBOLS, relativizeSymbols);
        return (W)this;
    }

    public final I getImportContainer() {
        return this.importContainer;
    }

    @Override
    public final List<SymbolDependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public final W addDependency(SymbolDependencyContainer dependencies) {
        List<SymbolDependency> values = dependencies.getDependencies();
        LOGGER.finest(() -> String.format("Adding dependencies from %s: %s", dependencies, values));
        this.dependencies.addAll(values);
        return (W)this;
    }

    public W addUseImports(SymbolContainer container) {
        for (Symbol symbol : container.getSymbols()) {
            this.addImport(symbol, symbol.getName(), SymbolReference.ContextOption.USE);
        }
        return (W)this;
    }

    public W addUseImports(SymbolReference symbolReference) {
        return this.addImport(symbolReference.getSymbol(), symbolReference.getAlias(), SymbolReference.ContextOption.USE);
    }

    public final W addImport(Symbol symbol, String alias, SymbolReference.ContextOption ... options) {
        LOGGER.finest(() -> String.format("Adding import %s as `%s` (%s)", symbol.getNamespace(), alias, Arrays.toString(options)));
        this.dependencies.addAll(symbol.getDependencies());
        this.importContainer.importSymbol(symbol, alias);
        this.addImportReferences(symbol, options);
        return (W)this;
    }

    final void addImportReferences(Symbol symbol, SymbolReference.ContextOption ... options) {
        block0: for (SymbolReference reference : symbol.getReferences()) {
            if (options.length == 0) {
                this.addImport(reference.getSymbol(), reference.getAlias(), options);
                continue;
            }
            for (SymbolReference.ContextOption option : options) {
                if (!reference.hasOption(option)) continue;
                this.addImport(reference.getSymbol(), reference.getAlias(), options);
                continue block0;
            }
        }
    }

    public abstract W writeDocs(Consumer<W> var1);

    public final W writeDocs(String docs) {
        this.writeDocs((W w) -> w.writeWithNoFormatting(docs));
        return (W)this;
    }

    private final class DefaultSymbolFormatter
    implements BiFunction<Object, String, String> {
        private DefaultSymbolFormatter() {
        }

        @Override
        public String apply(Object type, String indent) {
            if (type instanceof Symbol) {
                Symbol typeSymbol = (Symbol)type;
                SymbolWriter.this.addUseImports(typeSymbol);
                String relativizeSymbols = (String)SymbolWriter.this.getContext(SymbolWriter.RELATIVIZE_SYMBOLS, String.class);
                if (relativizeSymbols != null) {
                    return typeSymbol.relativize(relativizeSymbols);
                }
                return typeSymbol.toString();
            }
            if (type instanceof SymbolReference) {
                SymbolReference typeSymbol = (SymbolReference)type;
                SymbolWriter.this.addImport(typeSymbol.getSymbol(), typeSymbol.getAlias(), SymbolReference.ContextOption.USE);
                return typeSymbol.getAlias();
            }
            throw new CodegenException("Invalid type provided to $T. Expected a Symbol or SymbolReference, but found `" + type + "`");
        }
    }

    @FunctionalInterface
    public static interface Factory<W extends SymbolWriter<W, ? extends ImportContainer>>
    extends BiFunction<String, String, W> {
        @Override
        public W apply(String var1, String var2);
    }
}

