/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.function.BiPredicate;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ReservedWordSymbolProvider
implements SymbolProvider {
    private static final Logger LOGGER = Logger.getLogger(ReservedWordSymbolProvider.class.getName());
    private static final ReservedWords IDENTITY = ReservedWords.identity();
    private final SymbolProvider delegate;
    private final Escaper escaper;

    private ReservedWordSymbolProvider(SymbolProvider delegate, Escaper escaper) {
        this.delegate = delegate;
        this.escaper = escaper;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ReservedWords resolveReserved(ReservedWords specific) {
        return specific != null ? specific : IDENTITY;
    }

    @Override
    public Symbol toSymbol(Shape shape) {
        return this.escaper.escapeSymbol(shape, this.delegate.toSymbol(shape));
    }

    @Override
    public String toMemberName(MemberShape shape) {
        return this.escaper.escapeMemberName(this.delegate.toMemberName(shape));
    }

    public static final class Escaper {
        private final ReservedWords filenameReservedWords;
        private final ReservedWords namespaceReservedWords;
        private final ReservedWords nameReservedWords;
        private final ReservedWords memberReservedWords;
        private final BiPredicate<Shape, Symbol> escapePredicate;

        private Escaper(Builder builder) {
            this.filenameReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.filenameReservedWords);
            this.namespaceReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.namespaceReservedWords);
            this.nameReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.nameReservedWords);
            this.memberReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.memberReservedWords);
            this.escapePredicate = builder.escapePredicate;
        }

        public Symbol escapeSymbol(Shape shape, Symbol symbol) {
            if (!this.escapePredicate.test(shape, symbol)) {
                return symbol;
            }
            String newName = Escaper.convertWord("name", symbol.getName(), this.nameReservedWords);
            String newNamespace = Escaper.convertWord("namespace", symbol.getNamespace(), this.namespaceReservedWords);
            String newDeclarationFile = Escaper.convertWord("filename", symbol.getDeclarationFile(), this.filenameReservedWords);
            String newDefinitionFile = Escaper.convertWord("filename", symbol.getDefinitionFile(), this.filenameReservedWords);
            if (newName.equals(symbol.getName()) && newNamespace.equals(symbol.getNamespace()) && newDeclarationFile.equals(symbol.getDeclarationFile()) && newDefinitionFile.equals(symbol.getDeclarationFile())) {
                return symbol;
            }
            return symbol.toBuilder().name(newName).namespace(newNamespace, symbol.getNamespaceDelimiter()).declarationFile(newDeclarationFile).definitionFile(newDefinitionFile).build();
        }

        public String escapeMemberName(String memberName) {
            return Escaper.convertWord("member", memberName, this.memberReservedWords);
        }

        private static String convertWord(String name, String result, ReservedWords reservedWords) {
            if (!reservedWords.isReserved(result)) {
                return result;
            }
            String newResult = reservedWords.escape(result);
            LOGGER.warning(() -> String.format("Reserved word: %s is a reserved word for a %s. Converting to %s", result, name, newResult));
            return newResult;
        }
    }

    public static final class Builder {
        private SymbolProvider delegate;
        private ReservedWords filenameReservedWords;
        private ReservedWords namespaceReservedWords;
        private ReservedWords nameReservedWords;
        private ReservedWords memberReservedWords;
        private BiPredicate<Shape, Symbol> escapePredicate = (shape, symbol) -> true;

        public SymbolProvider build() {
            return new ReservedWordSymbolProvider((SymbolProvider)SmithyBuilder.requiredState((String)"delegate", (Object)this.delegate), this.buildEscaper());
        }

        public Escaper buildEscaper() {
            return new Escaper(this);
        }

        public Builder symbolProvider(SymbolProvider delegate) {
            this.delegate = delegate;
            return this;
        }

        public Builder filenameReservedWords(ReservedWords filenameReservedWords) {
            this.filenameReservedWords = filenameReservedWords;
            return this;
        }

        public Builder namespaceReservedWords(ReservedWords namespaceReservedWords) {
            this.namespaceReservedWords = namespaceReservedWords;
            return this;
        }

        public Builder nameReservedWords(ReservedWords nameReservedWords) {
            this.nameReservedWords = nameReservedWords;
            return this;
        }

        public Builder memberReservedWords(ReservedWords memberReservedWords) {
            this.memberReservedWords = memberReservedWords;
            return this;
        }

        public Builder escapePredicate(BiPredicate<Shape, Symbol> escapePredicate) {
            this.escapePredicate = escapePredicate;
            return this;
        }
    }
}

