/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core.trace;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.trace.ArtifactDefinitions;
import software.amazon.smithy.codegen.core.trace.ShapeLink;
import software.amazon.smithy.codegen.core.trace.TraceFile;
import software.amazon.smithy.codegen.core.trace.TraceMetadata;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;

public final class TracingSymbolProvider
implements SymbolProvider {
    private final TraceFile.Builder traceFileBuilder = new TraceFile.Builder();
    private final Set<ShapeId> visitedShapes = new HashSet<ShapeId>();
    private final SymbolProvider symbolProvider;
    private final BiFunction<Shape, Symbol, List<ShapeLink>> shapeLinkCreator;

    private TracingSymbolProvider(Builder builder) {
        this.symbolProvider = (SymbolProvider)SmithyBuilder.requiredState((String)"symbolProvider", (Object)builder.symbolProvider);
        this.shapeLinkCreator = (BiFunction)SmithyBuilder.requiredState((String)"shapeLinkCreator", (Object)builder.shapeLinkCreator);
        this.traceFileBuilder.metadata((TraceMetadata)SmithyBuilder.requiredState((String)"metadata", (Object)builder.metadata)).definitions(builder.artifactDefinitions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public TraceFile buildTraceFile() {
        return this.traceFileBuilder.build();
    }

    @Override
    public Symbol toSymbol(Shape shape) {
        List<ShapeLink> shapeLinks;
        Symbol symbol = this.symbolProvider.toSymbol(shape);
        ShapeId shapeId = shape.getId();
        if (this.visitedShapes.add(shapeId) && (shapeLinks = this.shapeLinkCreator.apply(shape, symbol)).size() > 0) {
            this.traceFileBuilder.addShapeLinks(shapeId, shapeLinks);
        }
        return symbol;
    }

    @Override
    public String toMemberName(MemberShape shape) {
        return this.symbolProvider.toMemberName(shape);
    }

    public static final class Builder
    implements SmithyBuilder<TracingSymbolProvider> {
        private SymbolProvider symbolProvider;
        private BiFunction<Shape, Symbol, List<ShapeLink>> shapeLinkCreator;
        private ArtifactDefinitions artifactDefinitions;
        private TraceMetadata metadata;

        public Builder artifactDefinitions(ArtifactDefinitions artifactDefinitions) {
            this.artifactDefinitions = artifactDefinitions;
            return this;
        }

        public Builder metadata(TraceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setTraceMetadataAsDefault(String artifactType) {
            String tempIdVersion = UUID.randomUUID().toString();
            this.metadata = TraceMetadata.builder().version(tempIdVersion).id(tempIdVersion).type(artifactType).setTimestampAsNow().build();
            return this;
        }

        public Builder shapeLinkCreator(BiFunction<Shape, Symbol, List<ShapeLink>> shapeLinkCreator) {
            this.shapeLinkCreator = shapeLinkCreator;
            return this;
        }

        public Builder symbolProvider(SymbolProvider symbolProvider) {
            this.symbolProvider = symbolProvider;
            return this;
        }

        public TracingSymbolProvider build() {
            return new TracingSymbolProvider(this);
        }
    }
}

