/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolContainer;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.TypedPropertiesBag;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SymbolReference
extends TypedPropertiesBag
implements SymbolContainer,
SymbolDependencyContainer,
ToSmithyBuilder<SymbolReference> {
    private final Symbol symbol;
    private final Set<Option> options;
    private final String alias;

    public SymbolReference(Symbol symbol, Option ... options) {
        this(symbol, Collections.emptyMap(), options);
    }

    public SymbolReference(Symbol symbol, Map<String, Object> properties, Option ... options) {
        this(((Builder)new Builder().symbol(symbol).properties((Map)properties)).options(options));
    }

    private SymbolReference(Builder builder) {
        super(builder.properties);
        this.symbol = (Symbol)SmithyBuilder.requiredState((String)"symbol", (Object)builder.symbol);
        this.alias = builder.alias == null ? builder.symbol.getName() : builder.alias;
        HashSet<ContextOption> opts = new HashSet<ContextOption>(builder.options.size() + 2);
        if (builder.options.size() == 0) {
            opts.add(ContextOption.USE);
            opts.add(ContextOption.DECLARE);
        } else {
            opts.addAll(builder.options);
        }
        this.options = Collections.unmodifiableSet(opts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String getAlias() {
        return this.alias;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean hasOption(Option option) {
        return this.options.contains(option);
    }

    @Override
    public List<Symbol> getSymbols() {
        return Collections.singletonList(this.getSymbol());
    }

    @Override
    public List<SymbolDependency> getDependencies() {
        return this.symbol.getDependencies();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().symbol(this.symbol).options(this.options).properties(this.getProperties())).alias(this.alias);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolReference)) {
            return false;
        }
        SymbolReference that = (SymbolReference)o;
        return super.equals(o) && this.symbol.equals(that.symbol) && this.getProperties().equals(that.getProperties()) && this.options.equals(that.options) && this.alias.equals(that.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.symbol, this.alias, this.getProperties());
    }

    public String toString() {
        return "SymbolReference{symbol=" + this.symbol + ", alias='" + this.alias + "', options=" + this.options + "}";
    }

    public static final class Builder
    extends TypedPropertiesBag.Builder<Builder>
    implements SmithyBuilder<SymbolReference> {
        private Symbol symbol;
        private Set<Option> options = new HashSet<Option>();
        private String alias;

        private Builder() {
        }

        public SymbolReference build() {
            return new SymbolReference(this);
        }

        public Builder symbol(Symbol symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder options(Set<Option> options) {
            this.options = options;
            return this;
        }

        public Builder options(Option ... options) {
            this.options = new HashSet<Option>();
            Collections.addAll(this.options, options);
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }
    }

    public static enum ContextOption implements Option
    {
        DECLARE,
        USE;

    }

    public static interface Option {
    }
}

