/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.utils.MapUtils;

class TypedPropertiesBag {
    private final Map<String, Object> properties;

    TypedPropertiesBag(Map<String, Object> properties) {
        this.properties = MapUtils.copyOf(properties);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public <T> Optional<T> getProperty(String name, Class<T> type) {
        return this.getProperty(name).map(value -> {
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(String.format("%s property `%s` of `%s` is not an instance of `%s`. Found `%s`", this.getClass().getSimpleName(), name, this, type.getName(), value.getClass().getName()));
            }
            return value;
        });
    }

    public Object expectProperty(String name) {
        return this.getProperty(name).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of %s, `%s`", name, this.getClass().getSimpleName(), this)));
    }

    public <T> T expectProperty(String name, Class<T> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of %s, `%s`", name, this.getClass().getSimpleName(), this)));
    }

    static abstract class Builder<T extends Builder> {
        Map<String, Object> properties = new HashMap<String, Object>();

        Builder() {
        }

        public T putProperty(String key, Object value) {
            this.properties.put(key, value);
            return (T)this;
        }

        public T removeProperty(String key) {
            this.properties.remove(key);
            return (T)this;
        }

        public T properties(Map<String, Object> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return (T)this;
        }
    }
}

