/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.TypedPropertiesBag;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SymbolDependency
extends TypedPropertiesBag
implements ToSmithyBuilder<SymbolDependency>,
Comparable<SymbolDependency> {
    private final String dependencyType;
    private final String packageName;
    private final String version;

    private SymbolDependency(Builder builder) {
        super(builder.properties);
        this.dependencyType = builder.dependencyType == null ? "" : builder.dependencyType;
        this.packageName = (String)SmithyBuilder.requiredState((String)"packageName", (Object)builder.packageName);
        this.version = (String)SmithyBuilder.requiredState((String)"version", (Object)builder.version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map<String, Map<String, SymbolDependency>> gatherDependencies(Stream<SymbolDependency> symbolStream) {
        return SymbolDependency.gatherDependencies(symbolStream, (a, b) -> {
            throw new CodegenException(String.format("Found a conflicting `%s` dependency for `%s`: `%s` conflicts with `%s`", a.getDependencyType(), a.getPackageName(), a.getVersion(), b.getVersion()));
        });
    }

    public static Map<String, Map<String, SymbolDependency>> gatherDependencies(Stream<SymbolDependency> symbolStream, BinaryOperator<SymbolDependency> versionMergeFunction) {
        return symbolStream.sorted().collect(Collectors.groupingBy(SymbolDependency::getDependencyType, Collectors.toMap(SymbolDependency::getPackageName, Function.identity(), SymbolDependency.guardedMerge(versionMergeFunction), TreeMap::new)));
    }

    private static BinaryOperator<SymbolDependency> guardedMerge(BinaryOperator<SymbolDependency> original) {
        return (a, b) -> {
            if (a.getVersion().equals(b.getVersion())) {
                return b;
            }
            return (SymbolDependency)original.apply((SymbolDependency)a, b);
        };
    }

    public String getDependencyType() {
        return this.dependencyType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public Builder toBuilder() {
        return (Builder)SymbolDependency.builder().dependencyType(this.dependencyType).packageName(this.packageName).version(this.version).properties(this.getProperties());
    }

    public String toString() {
        return "SymbolDependency{dependencyType='" + this.dependencyType + '\'' + ", packageName='" + this.packageName + '\'' + ", version='" + this.version + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolDependency)) {
            return false;
        }
        SymbolDependency that = (SymbolDependency)o;
        return this.dependencyType.equals(that.dependencyType) && this.packageName.equals(that.packageName) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.dependencyType, this.packageName, this.version);
    }

    @Override
    public int compareTo(SymbolDependency other) {
        int typeResult = this.dependencyType.compareTo(other.dependencyType);
        if (typeResult != 0) {
            return typeResult;
        }
        int packageResult = this.packageName.compareTo(other.packageName);
        if (packageResult != 0) {
            return packageResult;
        }
        return this.version.compareTo(other.version);
    }

    public static final class Builder
    extends TypedPropertiesBag.Builder<Builder>
    implements SmithyBuilder<SymbolDependency> {
        private String dependencyType = "";
        private String packageName;
        private String version;

        private Builder() {
        }

        public SymbolDependency build() {
            return new SymbolDependency(this);
        }

        public Builder dependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }
    }
}

