/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.TypedPropertiesBag;

public final class SymbolReference
extends TypedPropertiesBag {
    private final Symbol symbol;
    private final Set<Option> options;

    public SymbolReference(Symbol symbol, Option ... options) {
        this(symbol, Collections.emptyMap(), options);
    }

    public SymbolReference(Symbol symbol, Map<String, Object> properties, Option ... options) {
        super(properties);
        this.symbol = symbol;
        HashSet<ContextOption> opts = new HashSet<ContextOption>(options.length + 2);
        if (options.length == 0) {
            opts.add(ContextOption.USE);
            opts.add(ContextOption.DECLARE);
        } else {
            Collections.addAll(opts, options);
        }
        this.options = Collections.unmodifiableSet(opts);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean hasOption(Option option) {
        return this.options.contains(option);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolReference)) {
            return false;
        }
        SymbolReference that = (SymbolReference)o;
        return this.symbol.equals(that.symbol) && this.getProperties().equals(that.getProperties()) && this.options.equals(that.options);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.getProperties());
    }

    public String toString() {
        return "SymbolReference{symbol=" + this.symbol + ", options=" + this.options + '}';
    }

    public static enum ContextOption implements Option
    {
        DECLARE,
        USE;

    }

    public static interface Option {
    }
}

