/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.ReservedWords;

final class CaseInsensitiveReservedWords
implements ReservedWords {
    private final Set<String> words;
    private final Function<String, String> escaper;

    CaseInsensitiveReservedWords(Set<String> words, Function<String, String> escaper) {
        this.words = words.stream().map(word -> word.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        this.escaper = escaper;
    }

    @Override
    public String escape(String word) {
        return this.isReserved(word) ? this.escaper.apply(word) : word;
    }

    @Override
    public boolean isReserved(String word) {
        return this.words.contains(word.toLowerCase(Locale.ENGLISH));
    }
}

