/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Symbol
implements ToSmithyBuilder<Symbol> {
    private final String namespace;
    private final String namespaceDelimiter;
    private final String name;
    private final String definitionFile;
    private final String declarationFile;
    private final Map<String, Object> properties;

    private Symbol(Builder builder) {
        this.namespace = builder.namespace;
        this.namespaceDelimiter = builder.namespaceDelimiter;
        this.name = builder.name;
        this.declarationFile = builder.declarationFile;
        this.definitionFile = !builder.definitionFile.isEmpty() ? builder.definitionFile : this.declarationFile;
        this.properties = MapUtils.copyOf((Map)builder.properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceDelimiter() {
        return this.namespaceDelimiter;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclarationFile() {
        return this.declarationFile;
    }

    public String getDefinitionFile() {
        return this.definitionFile;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public <T> Optional<T> getProperty(String name, Class<T> type) {
        return this.getProperty(name).map(value -> {
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(String.format("Symbol property `%s` of `%s` is not an instance of `%s`", name, this, type.getName()));
            }
            return value;
        });
    }

    public Object expectProperty(String name) {
        return this.getProperty(name).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of Symbol, `%s`", name, this)));
    }

    public <T> T expectProperty(String name, Class<T> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IllegalArgumentException(String.format("Property `%s` is not part of Symbol, `%s`", name, this)));
    }

    public String getFullName() {
        return this.toString();
    }

    public String relativize(String namespace) {
        return this.namespace.equals(namespace) ? this.name : this.toString();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        return builder.namespace(this.namespace, this.namespaceDelimiter).name(this.name).properties(this.properties).definitionFile(this.definitionFile).declarationFile(this.declarationFile);
    }

    public String toString() {
        return this.namespace.isEmpty() ? this.name : this.namespace + this.namespaceDelimiter + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return Objects.equals(this.namespace, symbol.namespace) && Objects.equals(this.namespaceDelimiter, symbol.namespaceDelimiter) && Objects.equals(this.name, symbol.name) && Objects.equals(this.properties, symbol.properties) && Objects.equals(this.declarationFile, symbol.declarationFile) && Objects.equals(this.definitionFile, symbol.definitionFile);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.namespaceDelimiter, this.name);
    }

    public static final class Builder
    implements SmithyBuilder<Symbol> {
        private String name;
        private String namespace = "";
        private String namespaceDelimiter = "";
        private String definitionFile = "";
        private String declarationFile = "";
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Symbol build() {
            return new Symbol(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace, String namespaceDelimiter) {
            this.namespace = namespace == null ? "" : namespace;
            this.namespaceDelimiter = namespaceDelimiter == null ? "" : namespaceDelimiter;
            return this;
        }

        public Builder putProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder removeProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return this;
        }

        public Builder definitionFile(String definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        public Builder declarationFile(String declarationFile) {
            this.declarationFile = declarationFile;
            return this;
        }
    }
}

