/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.codegen.core;

import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ReservedWordSymbolProvider
implements SymbolProvider {
    private static final Logger LOGGER = Logger.getLogger(ReservedWordSymbolProvider.class.getName());
    private static final ReservedWords IDENTITY = ReservedWords.identity();
    private final SymbolProvider delegate;
    private final ReservedWords filenameReservedWords;
    private final ReservedWords namespaceReservedWords;
    private final ReservedWords nameReservedWords;
    private final ReservedWords memberReservedWords;

    private ReservedWordSymbolProvider(Builder builder) {
        this.delegate = (SymbolProvider)SmithyBuilder.requiredState((String)"symbolProvider", (Object)builder.delegate);
        this.filenameReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.filenameReservedWords);
        this.namespaceReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.namespaceReservedWords);
        this.nameReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.nameReservedWords);
        this.memberReservedWords = ReservedWordSymbolProvider.resolveReserved(builder.memberReservedWords);
    }

    private static ReservedWords resolveReserved(ReservedWords specific) {
        return specific != null ? specific : IDENTITY;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Symbol toSymbol(Shape shape) {
        Symbol upstream = this.delegate.toSymbol(shape);
        return upstream.toBuilder().name(this.nameReservedWords.escape(upstream.getName())).namespace(this.namespaceReservedWords.escape(upstream.getNamespace()), upstream.getNamespaceDelimiter()).declarationFile(this.filenameReservedWords.escape(upstream.getDeclarationFile())).definitionFile(this.filenameReservedWords.escape(upstream.getDefinitionFile())).build();
    }

    @Override
    public String toMemberName(Shape shape) {
        return ReservedWordSymbolProvider.convertWord("member", this.delegate.toMemberName(shape), this.memberReservedWords);
    }

    private static String convertWord(String name, String result, ReservedWords reservedWords) {
        if (!reservedWords.isReserved(result)) {
            return result;
        }
        String newResult = reservedWords.escape(result);
        LOGGER.warning(() -> String.format("Reserved word: %s is a reserved word for a %s. Converting to %s", result, name, newResult));
        return newResult;
    }

    public static final class Builder {
        private SymbolProvider delegate;
        private ReservedWords filenameReservedWords;
        private ReservedWords namespaceReservedWords;
        private ReservedWords nameReservedWords;
        private ReservedWords memberReservedWords;

        public SymbolProvider build() {
            return new ReservedWordSymbolProvider(this);
        }

        public Builder symbolProvider(SymbolProvider delegate) {
            this.delegate = delegate;
            return this;
        }

        public Builder filenameReservedWords(ReservedWords filenameReservedWords) {
            this.filenameReservedWords = filenameReservedWords;
            return this;
        }

        public Builder namespaceReservedWords(ReservedWords namespaceReservedWords) {
            this.namespaceReservedWords = namespaceReservedWords;
            return this;
        }

        public Builder nameReservedWords(ReservedWords nameReservedWords) {
            this.nameReservedWords = nameReservedWords;
            return this;
        }

        public Builder memberReservedWords(ReservedWords memberReservedWords) {
            this.memberReservedWords = memberReservedWords;
            return this;
        }
    }
}

