/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.ColorTheme;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.SmithyCli;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.commands.AstCommand;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.CleanCommand;
import software.amazon.smithy.cli.commands.DiffCommand;
import software.amazon.smithy.cli.commands.FormatCommand;
import software.amazon.smithy.cli.commands.InitCommand;
import software.amazon.smithy.cli.commands.LockCommand;
import software.amazon.smithy.cli.commands.MigrateCommand;
import software.amazon.smithy.cli.commands.SelectCommand;
import software.amazon.smithy.cli.commands.ValidateCommand;
import software.amazon.smithy.cli.commands.VersionCommand;
import software.amazon.smithy.cli.commands.WarmupCommand;
import software.amazon.smithy.cli.dependencies.DependencyResolver;

public final class SmithyCommand
implements Command {
    private final List<Command> commands;

    public SmithyCommand(DependencyResolver.Factory dependencyResolverFactory) {
        Objects.requireNonNull(dependencyResolverFactory);
        MigrateCommand migrateCommand = new MigrateCommand(this.getName());
        Command deprecated1To2Command = MigrateCommand.createDeprecatedAlias(migrateCommand);
        this.commands = Arrays.asList(new VersionCommand(), new ValidateCommand(this.getName(), dependencyResolverFactory), new BuildCommand(this.getName(), dependencyResolverFactory), new DiffCommand(this.getName(), dependencyResolverFactory), new AstCommand(this.getName(), dependencyResolverFactory), new SelectCommand(this.getName(), dependencyResolverFactory), new FormatCommand(this.getName()), new CleanCommand(this.getName()), migrateCommand, deprecated1To2Command, new WarmupCommand(this.getName()), new InitCommand(this.getName()), new LockCommand(this.getName(), dependencyResolverFactory));
    }

    @Override
    public String getName() {
        return "smithy";
    }

    @Override
    public String getSummary() {
        return "";
    }

    private void printHelp(ColorFormatter colors, CliPrinter printer) {
        printer.println(String.format("Usage: %s [-h | --help] [--version] <command> [<args>]", colors.style("smithy", ColorTheme.EM_UNDERLINE)));
        printer.println("");
        printer.println("Available commands:");
        int longestName = 0;
        for (Command command : this.commands) {
            if (command.isHidden() || command.getName().length() + 12 <= longestName) continue;
            longestName = command.getName().length() + 12;
        }
        for (Command command : this.commands) {
            if (command.isHidden()) continue;
            printer.println(String.format("    %-" + longestName + "s %s", colors.style(command.getName(), ColorTheme.LITERAL), command.getSummary()));
        }
        printer.println("");
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        EnvironmentVariable.SMITHY_VERSION.set(SmithyCli.getVersion());
        String command = arguments.shift();
        if (command == null) {
            arguments.getPositional();
            if (arguments.getReceiver(StandardOptions.class).help()) {
                this.printHelp(env.colors(), env.stdout());
                return 0;
            }
            this.printHelp(env.colors(), env.stderr());
            return 1;
        }
        for (Command c : this.commands) {
            if (!c.getName().equals(command)) continue;
            return c.execute(arguments, env);
        }
        throw new CliError("Unknown argument or command: " + command);
    }
}

