/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.wire;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.smithy.cli.shaded.google.inject.Injector;
import software.amazon.smithy.cli.shaded.google.inject.Singleton;
import software.amazon.smithy.cli.shaded.google.inject.TypeLiteral;
import software.amazon.smithy.cli.shaded.google.inject.spi.TypeConverter;
import software.amazon.smithy.cli.shaded.google.inject.spi.TypeConverterBinding;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type) {
        TypeConverter converter = this.converterMap.get(type);
        if (null == converter) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type, converter);
                break;
            }
        }
        return converter;
    }
}

