/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.FailChecksumPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.WarnChecksumPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.TransferResource;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named
public final class DefaultChecksumPolicyProvider
implements ChecksumPolicyProvider {
    private static final int ORDINAL_IGNORE = 0;
    private static final int ORDINAL_WARN = 1;
    private static final int ORDINAL_FAIL = 2;

    @Override
    public ChecksumPolicy newChecksumPolicy(RepositorySystemSession session, RemoteRepository repository, TransferResource resource, String policy) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        Objects.requireNonNull(resource, "resource cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy", policy);
        switch (policy) {
            case "ignore": {
                return null;
            }
            case "fail": {
                return new FailChecksumPolicy(resource);
            }
            case "warn": {
                return new WarnChecksumPolicy(resource);
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    @Override
    public String getEffectiveChecksumPolicy(RepositorySystemSession session, String policy1, String policy2) {
        Objects.requireNonNull(session, "session cannot be null");
        DefaultChecksumPolicyProvider.validatePolicy("policy1", policy1);
        DefaultChecksumPolicyProvider.validatePolicy("policy2", policy2);
        if (policy1.equals(policy2)) {
            return policy1;
        }
        int ordinal1 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy1);
        int ordinal2 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy2);
        if (ordinal2 < ordinal1) {
            return ordinal2 != 1 ? policy2 : "warn";
        }
        return ordinal1 != 1 ? policy1 : "warn";
    }

    private static int ordinalOfPolicy(String policy) {
        switch (policy) {
            case "ignore": {
                return 0;
            }
            case "fail": {
                return 2;
            }
            case "warn": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported policy: " + policy);
    }

    private static void validatePolicy(String paramName, String policy) {
        Objects.requireNonNull(policy, paramName + "cannot be null");
        switch (policy) {
            case "ignore": 
            case "fail": 
            case "warn": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported policy: " + policy);
            }
        }
    }
}

