/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.util.graph.version;

import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.Artifact;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.DependencyCollectionContext;
import software.amazon.smithy.cli.shaded.eclipse.aether.collection.VersionFilter;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.graph.version.SnapshotVersionFilter;

public final class ContextualSnapshotVersionFilter
implements VersionFilter {
    public static final String CONFIG_PROP_ENABLE = "aether.snapshotFilter";
    private final SnapshotVersionFilter filter = new SnapshotVersionFilter();

    private boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_ENABLE);
    }

    @Override
    public void filterVersions(VersionFilter.VersionFilterContext context) {
        if (this.isEnabled(context.getSession())) {
            this.filter.filterVersions(context);
        }
    }

    @Override
    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        if (!this.isEnabled(context.getSession())) {
            Artifact artifact = context.getArtifact();
            if (artifact == null) {
                return this;
            }
            if (artifact.isSnapshot()) {
                return null;
            }
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

