/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.Objects;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.DefaultLocalPathComposer;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.LocalPathComposer;
import software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.LocalRepositoryManager;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.NoLocalRepositoryManagerException;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.Service;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.locator.ServiceLocator;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Singleton
@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private float priority;
    private LocalPathComposer localPathComposer;

    public SimpleLocalRepositoryManagerFactory() {
        this.localPathComposer = new DefaultLocalPathComposer();
    }

    @Inject
    public SimpleLocalRepositoryManagerFactory(LocalPathComposer localPathComposer) {
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.localPathComposer = Objects.requireNonNull(locator.getService(LocalPathComposer.class));
    }

    @Override
    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir(), "simple", this.localPathComposer);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public SimpleLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

