/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.dependencies.DependencyResolverException;
import software.amazon.smithy.cli.dependencies.ResolvedArtifact;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

final class LockFile
implements ToSmithyBuilder<LockFile>,
ToNode {
    private static final Path LOCK_FILE = Paths.get("smithy-lock.json", new String[0]);
    private static final String DEFAULT_VERSION = "1.0";
    private static final String WARNING_STR = "AUTOGENERATED_DO_NOT_MODIFY";
    private static final String VERSION_NAME = "version";
    private static final String CONFIG_HASH_NAME = "configHash";
    private static final String ARTIFACT_LIST_NAME = "artifacts";
    private static final String REPOSITORIES_LIST_NAME = "repositories";
    private static final List<String> EXPECTED_PROPERTIES = ListUtils.of((Object[])new String[]{"AUTOGENERATED_DO_NOT_MODIFY", "version", "configHash", "artifacts", "repositories"});
    private final Map<String, LockedArtifact> artifacts;
    private final Set<String> repositories;
    private final int configHash;
    private final String version;

    private LockFile(Builder builder) {
        this.artifacts = (Map)builder.artifacts.copy();
        this.repositories = (Set)builder.repositories.copy();
        this.version = builder.version;
        this.configHash = builder.configHash;
    }

    public static LockFile fromNode(Node node) {
        Builder builder = LockFile.builder();
        node.expectObjectNode().warnIfAdditionalProperties(EXPECTED_PROPERTIES).getStringMember(VERSION_NAME, builder::version).getNumberMember(CONFIG_HASH_NAME, n -> builder.configHash(n.intValue())).getObjectMember(ARTIFACT_LIST_NAME, artifactList -> {
            for (Map.Entry entry : artifactList.getStringMap().entrySet()) {
                builder.artifact(LockedArtifact.fromCoordinateNode((String)entry.getKey(), (Node)entry.getValue()));
            }
        }).getArrayMember(REPOSITORIES_LIST_NAME, StringNode::getValue, builder::repositories);
        return builder.build();
    }

    public static Optional<LockFile> load() {
        return LockFile.load(LOCK_FILE);
    }

    public static Optional<LockFile> load(Path path) {
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            String contents = IoUtils.readUtf8File((Path)path);
            Node result = Node.parseJsonWithComments((String)contents);
            return Optional.of(LockFile.fromNode(result));
        }
        return Optional.empty();
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember(WARNING_STR, "").withMember(VERSION_NAME, this.version).withMember(CONFIG_HASH_NAME, (Number)this.configHash).withMember(REPOSITORIES_LIST_NAME, (ToNode)ArrayNode.fromStrings(this.repositories));
        ObjectNode.Builder artifactNodeBuilder = Node.objectNodeBuilder();
        for (LockedArtifact artifact : this.artifacts.values()) {
            artifactNodeBuilder.withMember(artifact.coordinates, (ToNode)artifact.toNode());
        }
        builder.withMember(ARTIFACT_LIST_NAME, (ToNode)artifactNodeBuilder.build());
        return builder.build();
    }

    public void validateArtifacts(List<ResolvedArtifact> resolvedArtifacts) {
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            LockedArtifact pin = this.artifacts.get(artifact.getCoordinates());
            if (pin == null) {
                throw new CliError("Resolved artifact `" + artifact + "` not found in locked artifacts.");
            }
            if (pin.matchesResolved(artifact)) continue;
            throw new CliError("Resolved artifact `" + artifact + "` does not match locked artifact `" + pin + "`");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getConfigHash() {
        return this.configHash;
    }

    public Set<String> getDependencyCoordinateSet() {
        return this.artifacts.keySet();
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getRepositories() {
        return this.repositories;
    }

    public void save() {
        try {
            Files.write(LOCK_FILE, Node.printJson((Node)this.toNode()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Builder toBuilder() {
        return LockFile.builder().repositories((Collection<String>)this.repositories).artifacts(this.artifacts).version(this.version).configHash(this.configHash);
    }

    public static final class Builder
    implements SmithyBuilder<LockFile> {
        private final BuilderRef<Map<String, LockedArtifact>> artifacts = BuilderRef.forOrderedMap();
        private final BuilderRef<Set<String>> repositories = BuilderRef.forOrderedSet();
        private String version = "1.0";
        private int configHash;

        public Builder artifacts(Map<String, LockedArtifact> artifacts) {
            this.artifacts.clear();
            ((Map)this.artifacts.get()).putAll(artifacts);
            return this;
        }

        public Builder artifacts(Collection<ResolvedArtifact> artifacts) {
            this.artifacts.clear();
            for (ResolvedArtifact artifact : artifacts) {
                ((Map)this.artifacts.get()).put(artifact.getCoordinates(), LockedArtifact.from(artifact));
            }
            return this;
        }

        public Builder artifact(ResolvedArtifact artifact) {
            ((Map)this.artifacts.get()).put(artifact.getCoordinates(), LockedArtifact.from(artifact));
            return this;
        }

        public Builder artifact(LockedArtifact artifact) {
            ((Map)this.artifacts.get()).put(artifact.coordinates, artifact);
            return this;
        }

        public Builder repositories(Set<MavenRepository> repositories) {
            this.repositories.clear();
            for (MavenRepository repository : repositories) {
                ((Set)this.repositories.get()).add(repository.getUrl());
            }
            return this;
        }

        public Builder repositories(Collection<String> repositories) {
            this.repositories.clear();
            ((Set)this.repositories.get()).addAll(repositories);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder configHash(int configHash) {
            this.configHash = configHash;
            return this;
        }

        public LockFile build() {
            return new LockFile(this);
        }
    }

    private static final class LockedArtifact
    implements ToNode {
        private static final String SHA_SUM_MEMBER_NAME = "sha1";
        private final String coordinates;
        private final String shaSum;

        private LockedArtifact(String coordinates, String shaSum) {
            this.coordinates = coordinates;
            this.shaSum = shaSum;
        }

        private static LockedArtifact from(ResolvedArtifact resolvedArtifact) {
            return new LockedArtifact(resolvedArtifact.getCoordinates(), resolvedArtifact.getShaSum());
        }

        private static LockedArtifact fromCoordinateNode(String coordinates, Node node) {
            String[] parts = coordinates.split(":");
            if (parts.length != 3) {
                throw new DependencyResolverException("Invalid Locked coordinates: " + coordinates);
            }
            ObjectNode objectNode = node.expectObjectNode();
            String shaSum = objectNode.expectMember(SHA_SUM_MEMBER_NAME).expectStringNode().getValue();
            return new LockedArtifact(coordinates, shaSum);
        }

        public Node toNode() {
            return Node.objectNodeBuilder().withMember(SHA_SUM_MEMBER_NAME, this.shaSum).build();
        }

        boolean matchesResolved(ResolvedArtifact resolved) {
            return this.shaSum.equals(resolved.getShaSum());
        }
    }
}

