/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.ArtifactTransportListener;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.ChecksumValidator;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.MetadataTransportListener;
import software.amazon.smithy.cli.shaded.eclipse.aether.connector.basic.TransferTransportListener;
import software.amazon.smithy.cli.shaded.eclipse.aether.repository.RemoteRepository;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.ArtifactDownload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.ArtifactUpload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.MetadataDownload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.MetadataUpload;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.RepositoryConnector;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.layout.RepositoryLayout;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.GetTask;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.PeekTask;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.PutTask;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.Transporter;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.connector.transport.TransporterProvider;
import software.amazon.smithy.cli.shaded.eclipse.aether.spi.io.FileProcessor;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.ChecksumFailureException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.NoRepositoryConnectorException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.NoRepositoryLayoutException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.NoTransporterException;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.TransferEvent;
import software.amazon.smithy.cli.shaded.eclipse.aether.transfer.TransferResource;
import software.amazon.smithy.cli.shaded.eclipse.aether.transform.FileTransformer;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.ConfigUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.FileUtils;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import software.amazon.smithy.cli.shaded.eclipse.aether.util.concurrency.WorkerThreadFactory;
import software.amazon.smithy.cli.shaded.slf4j.Logger;
import software.amazon.smithy.cli.shaded.slf4j.LoggerFactory;

final class BasicRepositoryConnector
implements RepositoryConnector {
    private static final String CONFIG_PROP_THREADS = "aether.connector.basic.threads";
    private static final String CONFIG_PROP_SMART_CHECKSUMS = "aether.connector.smartChecksums";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRepositoryConnector.class);
    private final Map<String, ProvidedChecksumsSource> providedChecksumsSources;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final Transporter transporter;
    private final RepositoryLayout layout;
    private final ChecksumPolicyProvider checksumPolicyProvider;
    private final int maxThreads;
    private final boolean smartChecksums;
    private final boolean persistedChecksums;
    private Executor executor;
    private final AtomicBoolean closed;

    BasicRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor, Map<String, ProvidedChecksumsSource> providedChecksumsSources) throws NoRepositoryConnectorException {
        try {
            this.layout = layoutProvider.newRepositoryLayout(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), e);
        }
        try {
            this.transporter = transporterProvider.newTransporter(session, repository);
        }
        catch (NoTransporterException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), e);
        }
        this.checksumPolicyProvider = checksumPolicyProvider;
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.providedChecksumsSources = providedChecksumsSources;
        this.closed = new AtomicBoolean(false);
        this.maxThreads = ConfigUtils.getInteger(session, 5, CONFIG_PROP_THREADS, "maven.artifact.threads");
        this.smartChecksums = ConfigUtils.getBoolean(session, true, CONFIG_PROP_SMART_CHECKSUMS);
        this.persistedChecksums = ConfigUtils.getBoolean(session, true, "aether.connector.persistedChecksums");
    }

    private Executor getExecutor(Collection<?> artifacts, Collection<?> metadatas) {
        if (this.maxThreads <= 1) {
            return DirectExecutor.INSTANCE;
        }
        int tasks = BasicRepositoryConnector.safe(artifacts).size() + BasicRepositoryConnector.safe(metadatas).size();
        if (tasks <= 1) {
            return DirectExecutor.INSTANCE;
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(this.getClass().getSimpleName() + '-' + this.repository.getHost() + '-'));
        }
        return this.executor;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.transporter.close();
        }
    }

    private void failIfClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("connector already closed");
        }
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        this.failIfClosed();
        Executor executor = this.getExecutor(artifactDownloads, metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        List<ChecksumAlgorithmFactory> checksumAlgorithmFactories = this.layout.getChecksumAlgorithmFactories();
        for (MetadataDownload metadataDownload : BasicRepositoryConnector.safe(metadataDownloads)) {
            URI location = this.layout.getLocation(metadataDownload.getMetadata(), false);
            TransferResource resource = this.newTransferResource(location, metadataDownload.getFile(), metadataDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, false);
            MetadataTransportListener listener = new MetadataTransportListener(metadataDownload, this.repository, builder);
            ChecksumPolicy checksumPolicy = this.newChecksumPolicy(metadataDownload.getChecksumPolicy(), resource);
            List<RepositoryLayout.ChecksumLocation> checksumLocations = null;
            if (checksumPolicy != null) {
                checksumLocations = this.layout.getChecksumLocations(metadataDownload.getMetadata(), false, location);
            }
            GetTaskRunner task = new GetTaskRunner(location, metadataDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, null, listener);
            executor.execute(errorForwarder.wrap(task));
        }
        for (ArtifactDownload artifactDownload : BasicRepositoryConnector.safe(artifactDownloads)) {
            TaskRunner task;
            Map<String, String> providedChecksums = Collections.emptyMap();
            for (ProvidedChecksumsSource providedChecksumsSource : this.providedChecksumsSources.values()) {
                Map<String, String> provided = providedChecksumsSource.getProvidedArtifactChecksums(this.session, artifactDownload, checksumAlgorithmFactories);
                if (provided == null) continue;
                providedChecksums = provided;
                break;
            }
            URI location = this.layout.getLocation(artifactDownload.getArtifact(), false);
            TransferResource resource = this.newTransferResource(location, artifactDownload.getFile(), artifactDownload.getTrace());
            TransferEvent.Builder builder = this.newEventBuilder(resource, false, artifactDownload.isExistenceCheck());
            ArtifactTransportListener listener = new ArtifactTransportListener(artifactDownload, this.repository, builder);
            if (artifactDownload.isExistenceCheck()) {
                task = new PeekTaskRunner(location, listener);
            } else {
                ChecksumPolicy checksumPolicy = this.newChecksumPolicy(artifactDownload.getChecksumPolicy(), resource);
                List<RepositoryLayout.ChecksumLocation> checksumLocations = null;
                if (checksumPolicy != null) {
                    checksumLocations = this.layout.getChecksumLocations(artifactDownload.getArtifact(), false, location);
                }
                task = new GetTaskRunner(location, artifactDownload.getFile(), checksumPolicy, checksumAlgorithmFactories, checksumLocations, providedChecksums, listener);
            }
            executor.execute(errorForwarder.wrap(task));
        }
        errorForwarder.await();
    }

    @Override
    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTaskRunner task;
        List<RepositoryLayout.ChecksumLocation> checksumLocations;
        TransferTransportListener listener;
        TransferEvent.Builder builder;
        TransferResource resource;
        URI location;
        this.failIfClosed();
        for (ArtifactUpload artifactUpload : BasicRepositoryConnector.safe(artifactUploads)) {
            location = this.layout.getLocation(artifactUpload.getArtifact(), true);
            resource = this.newTransferResource(location, artifactUpload.getFile(), artifactUpload.getTrace());
            builder = this.newEventBuilder(resource, true, false);
            listener = new ArtifactTransportListener(artifactUpload, this.repository, builder);
            checksumLocations = this.layout.getChecksumLocations(artifactUpload.getArtifact(), true, location);
            task = new PutTaskRunner(location, artifactUpload.getFile(), artifactUpload.getFileTransformer(), checksumLocations, listener);
            task.run();
        }
        for (MetadataUpload metadataUpload : BasicRepositoryConnector.safe(metadataUploads)) {
            location = this.layout.getLocation(metadataUpload.getMetadata(), true);
            resource = this.newTransferResource(location, metadataUpload.getFile(), metadataUpload.getTrace());
            builder = this.newEventBuilder(resource, true, false);
            listener = new MetadataTransportListener(metadataUpload, this.repository, builder);
            checksumLocations = this.layout.getChecksumLocations(metadataUpload.getMetadata(), true, location);
            task = new PutTaskRunner(location, metadataUpload.getFile(), checksumLocations, listener);
            task.run();
        }
    }

    private static <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private TransferResource newTransferResource(URI path, File file, RequestTrace trace) {
        return new TransferResource(this.repository.getId(), this.repository.getUrl(), path.toString(), file, trace);
    }

    private TransferEvent.Builder newEventBuilder(TransferResource resource, boolean upload, boolean peek) {
        TransferEvent.Builder builder = new TransferEvent.Builder(this.session, resource);
        if (upload) {
            builder.setRequestType(TransferEvent.RequestType.PUT);
        } else if (!peek) {
            builder.setRequestType(TransferEvent.RequestType.GET);
        } else {
            builder.setRequestType(TransferEvent.RequestType.GET_EXISTENCE);
        }
        return builder;
    }

    private ChecksumPolicy newChecksumPolicy(String policy, TransferResource resource) {
        return this.checksumPolicyProvider.newChecksumPolicy(this.session, this.repository, resource, policy);
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    private static class DirectExecutor
    implements Executor {
        static final Executor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    class GetTaskRunner
    extends TaskRunner
    implements ChecksumValidator.ChecksumFetcher {
        private final File file;
        private final ChecksumValidator checksumValidator;

        GetTaskRunner(URI path, File file, ChecksumPolicy checksumPolicy, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, List<RepositoryLayout.ChecksumLocation> checksumLocations, Map<String, String> providedChecksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "destination file cannot be null");
            this.checksumValidator = new ChecksumValidator(file, checksumAlgorithmFactories, BasicRepositoryConnector.this.fileProcessor, this, checksumPolicy, providedChecksums, BasicRepositoryConnector.safe(checksumLocations));
        }

        @Override
        public boolean fetchChecksum(URI remote, File local) throws Exception {
            try {
                BasicRepositoryConnector.this.transporter.get(new GetTask(remote).setDataFile(local));
            }
            catch (Exception e) {
                if (BasicRepositoryConnector.this.transporter.classify(e) == 1) {
                    return false;
                }
                throw e;
            }
            return true;
        }

        @Override
        protected void runTask() throws Exception {
            try (FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile(this.file.toPath());){
                File tmp = tempFile.getPath().toFile();
                this.listener.setChecksumCalculator(this.checksumValidator.newChecksumCalculator(tmp));
                int firstTrial = 0;
                int lastTrial = 1;
                int trial = firstTrial;
                while (true) {
                    GetTask task = new GetTask(this.path).setDataFile(tmp, false).setListener(this.listener);
                    BasicRepositoryConnector.this.transporter.get(task);
                    try {
                        this.checksumValidator.validate(this.listener.getChecksums(), BasicRepositoryConnector.this.smartChecksums ? task.getChecksums() : null);
                    }
                    catch (ChecksumFailureException e) {
                        boolean retry;
                        boolean bl = retry = trial < lastTrial && e.isRetryWorthy();
                        if (!retry && !this.checksumValidator.handle(e)) {
                            throw e;
                        }
                        this.listener.transferCorrupted(e);
                        if (!retry) break;
                        this.checksumValidator.retry();
                        ++trial;
                        continue;
                    }
                    break;
                }
                tempFile.move();
                if (BasicRepositoryConnector.this.persistedChecksums) {
                    this.checksumValidator.commit();
                }
            }
        }
    }

    class PeekTaskRunner
    extends TaskRunner {
        PeekTaskRunner(URI path, TransferTransportListener<?> listener) {
            super(path, listener);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }
    }

    class PutTaskRunner
    extends TaskRunner {
        private final File file;
        private final FileTransformer fileTransformer;
        private final Collection<RepositoryLayout.ChecksumLocation> checksumLocations;

        PutTaskRunner(URI path, File file, List<RepositoryLayout.ChecksumLocation> checksumLocations, TransferTransportListener<?> listener) {
            this(path, file, null, checksumLocations, listener);
        }

        PutTaskRunner(URI path, File file, FileTransformer fileTransformer, List<RepositoryLayout.ChecksumLocation> checksumLocations, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = Objects.requireNonNull(file, "source file cannot be null");
            this.fileTransformer = fileTransformer;
            this.checksumLocations = BasicRepositoryConnector.safe(checksumLocations);
        }

        @Override
        protected void runTask() throws Exception {
            if (this.fileTransformer != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try (InputStream transformData = this.fileTransformer.transformData(this.file);){
                    int read;
                    while ((read = transformData.read(buffer, 0, buffer.length)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                }
                byte[] bytes = baos.toByteArray();
                BasicRepositoryConnector.this.transporter.put(new PutTask(this.path).setDataBytes(bytes).setListener(this.listener));
                this.uploadChecksums(this.file, bytes);
            } else {
                BasicRepositoryConnector.this.transporter.put(new PutTask(this.path).setDataFile(this.file).setListener(this.listener));
                this.uploadChecksums(this.file, null);
            }
        }

        private void uploadChecksums(File file, byte[] bytes) {
            if (this.checksumLocations.isEmpty()) {
                return;
            }
            try {
                ArrayList<ChecksumAlgorithmFactory> algorithms = new ArrayList<ChecksumAlgorithmFactory>();
                for (RepositoryLayout.ChecksumLocation checksumLocation : this.checksumLocations) {
                    algorithms.add(checksumLocation.getChecksumAlgorithmFactory());
                }
                Map<String, String> sumsByAlgo = bytes != null ? ChecksumAlgorithmHelper.calculate(bytes, algorithms) : ChecksumAlgorithmHelper.calculate(file, algorithms);
                for (RepositoryLayout.ChecksumLocation checksumLocation : this.checksumLocations) {
                    this.uploadChecksum(checksumLocation.getLocation(), sumsByAlgo.get(checksumLocation.getChecksumAlgorithmFactory().getName()));
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to upload checksums for {}", (Object)file, (Object)e);
                throw new UncheckedIOException(e);
            }
        }

        private void uploadChecksum(URI location, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                BasicRepositoryConnector.this.transporter.put(new PutTask(location).setDataString((String)checksum));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to upload checksum to {}", (Object)location, (Object)e);
            }
        }
    }

    abstract class TaskRunner
    implements Runnable {
        protected final URI path;
        protected final TransferTransportListener<?> listener;

        TaskRunner(URI path, TransferTransportListener<?> listener) {
            this.path = path;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.transferInitiated();
                this.runTask();
                this.listener.transferSucceeded();
            }
            catch (Exception e) {
                this.listener.transferFailed(e, BasicRepositoryConnector.this.transporter.classify(e));
            }
        }

        protected abstract void runTask() throws Exception;
    }
}

