/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.sisu.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.sisu.bean.BeanLifecycle;
import software.amazon.smithy.cli.shaded.javax.annotation.PostConstruct;
import software.amazon.smithy.cli.shaded.javax.annotation.PreDestroy;

final class LifecycleBuilder {
    private final List<Method> startMethods = new ArrayList<Method>();
    private final List<Method> stopMethods = new ArrayList<Method>();
    private final List<Class<?>> hierarchy = new ArrayList();

    LifecycleBuilder() {
    }

    public synchronized BeanLifecycle build(Class<?> clazz) {
        try {
            Class<?> c = clazz;
            while (c != null && c != Object.class) {
                this.addLifecycleMethods(c);
                c = c.getSuperclass();
            }
            if (this.startMethods.isEmpty() && this.stopMethods.isEmpty()) {
                BeanLifecycle beanLifecycle = BeanLifecycle.NO_OP;
                return beanLifecycle;
            }
            BeanLifecycle beanLifecycle = new BeanLifecycle(this.startMethods, this.stopMethods);
            return beanLifecycle;
        }
        finally {
            this.startMethods.clear();
            this.stopMethods.clear();
            this.hierarchy.clear();
        }
    }

    private void addLifecycleMethods(Class<?> clazz) {
        boolean foundStartMethod = false;
        boolean foundStopMethod = false;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (LifecycleBuilder.isCandidateMethod(m)) {
                if (m.isAnnotationPresent(PostConstruct.class)) {
                    foundStartMethod = true;
                    if (!this.isOverridden(m)) {
                        this.startMethods.add(m);
                    }
                } else if (m.isAnnotationPresent(PreDestroy.class)) {
                    foundStopMethod = true;
                    if (!this.isOverridden(m)) {
                        this.stopMethods.add(m);
                    }
                }
                if (foundStartMethod && foundStopMethod) break;
            }
            ++n2;
        }
        this.hierarchy.add(clazz);
    }

    private boolean isOverridden(Method method) {
        String name = method.getName();
        int i = this.hierarchy.size() - 1;
        while (i >= 0) {
            Method[] methodArray = this.hierarchy.get(i).getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (name.equals(m.getName()) && LifecycleBuilder.isCandidateMethod(m)) {
                    int modifiers = m.getModifiers();
                    if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && (Modifier.isPrivate(modifiers) || !LifecycleBuilder.samePackage(method, m))) break;
                    return true;
                }
                ++n2;
            }
            --i;
        }
        return false;
    }

    private static boolean isCandidateMethod(Method method) {
        int modifiers;
        if (!(method.getReturnType() != Void.TYPE || Modifier.isStatic(modifiers = method.getModifiers()) || Modifier.isAbstract(modifiers) || method.isSynthetic())) {
            return method.getParameterTypes().length == 0;
        }
        return false;
    }

    private static boolean samePackage(Method lhs, Method rhs) {
        return lhs.getDeclaringClass().getPackage().equals(rhs.getDeclaringClass().getPackage());
    }
}

