/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.superpom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import software.amazon.smithy.cli.shaded.apache.maven.model.InputSource;
import software.amazon.smithy.cli.shaded.apache.maven.model.Model;
import software.amazon.smithy.cli.shaded.apache.maven.model.building.ModelProcessor;
import software.amazon.smithy.cli.shaded.apache.maven.model.superpom.SuperPomProvider;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private Model superModel;
    @Inject
    private ModelProcessor modelProcessor;

    public DefaultSuperPomProvider setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    @Override
    public Model getSuperModel(String version) {
        if (this.superModel == null) {
            String resource = "/software/amazon/smithy/cli/shaded/apache/maven/model/pom-" + version + ".xml";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("The super POM " + resource + " was not found, please verify the integrity of your Maven installation");
            }
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("xml:4.0.0", "xml:4.0.0");
                String modelId = "software.amazon.smithy.cli.shaded.apache.maven:maven-model-builder:" + this.getClass().getPackage().getImplementationVersion() + ":super-pom";
                InputSource inputSource = new InputSource();
                inputSource.setModelId(modelId);
                inputSource.setLocation(this.getClass().getResource(resource).toExternalForm());
                options.put("software.amazon.smithy.cli.shaded.apache.maven.model.io.inputSource", inputSource);
                this.superModel = this.modelProcessor.read(is, options);
            }
            catch (IOException e) {
                throw new IllegalStateException("The super POM " + resource + " is damaged, please verify the integrity of your Maven installation", e);
            }
        }
        return this.superModel;
    }
}

