/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl.collect;

import java.util.HashMap;
import java.util.Map;
import software.amazon.smithy.cli.shaded.eclipse.aether.RepositorySystemSession;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.ArtifactType;
import software.amazon.smithy.cli.shaded.eclipse.aether.artifact.ArtifactTypeRegistry;

public class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session) {
        return CachingArtifactTypeRegistry.newInstance(session.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate) {
        return delegate != null ? new CachingArtifactTypeRegistry(delegate) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate) {
        this.delegate = delegate;
        this.types = new HashMap<String, ArtifactType>();
    }

    @Override
    public ArtifactType get(String typeId) {
        ArtifactType type = this.types.get(typeId);
        if (type == null) {
            type = this.delegate.get(typeId);
            this.types.put(typeId, type);
        }
        return type;
    }
}

