/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.SmithyCli;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.HelpActionWrapper;
import software.amazon.smithy.cli.commands.ValidateCommand;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.cli.dependencies.MavenDependencyResolver;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.StringUtils;

final class WarmupCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(WarmupCommand.class.getName());
    private final String parentCommandName;

    WarmupCommand(String parentCommandName) {
        this.parentCommandName = parentCommandName;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        arguments.addReceiver(new Config());
        HelpActionWrapper action = HelpActionWrapper.fromCommand(this, this.parentCommandName, this::run);
        return action.apply(arguments, env);
    }

    @Override
    public String getName() {
        return "warmup";
    }

    @Override
    public String getSummary() {
        return "Creates caches that speed up the CLI. This is typically performed during the installation.";
    }

    private int run(Arguments arguments, Command.Env env) {
        boolean isDebug = arguments.getReceiver(StandardOptions.class).debug();
        Phase phase = arguments.getReceiver(Config.class).phase;
        LOGGER.info(() -> "Optimizing the Smithy CLI: " + (Object)((Object)phase));
        switch (phase) {
            case WRAPPER: {
                return this.orchestrate(isDebug, env.stderr());
            }
        }
        return this.runCodeToOptimize(arguments, env);
    }

    private int orchestrate(boolean isDebug, CliPrinter printer) {
        ArrayList<String> baseArgs = new ArrayList<String>();
        String classpath = this.getOrThrowIfUndefinedProperty("java.class.path");
        Path javaHome = Paths.get(this.getOrThrowIfUndefinedProperty("java.home"), new String[0]);
        Path lib = javaHome.resolve("lib");
        Path bin = javaHome.resolve("bin");
        Path windowsBinary = bin.resolve("java.exe");
        Path posixBinary = bin.resolve("java");
        Path jsaFile = lib.resolve("smithy.jsa");
        Path classListFile = lib.resolve("classlist");
        classListFile.toFile().delete();
        jsaFile.toFile().delete();
        if (!Files.isDirectory(bin, new LinkOption[0])) {
            throw new CliError("$JAVA_HOME/bin directory not found: " + bin);
        }
        if (Files.exists(windowsBinary, new LinkOption[0])) {
            baseArgs.add(windowsBinary.toString());
        } else if (Files.exists(posixBinary, new LinkOption[0])) {
            baseArgs.add(posixBinary.toString());
        } else {
            throw new CliError("No java binary found in " + bin);
        }
        baseArgs.add("-classpath");
        baseArgs.add(classpath);
        try {
            Path baseDir = Files.createTempDirectory("smithy-warmup", new FileAttribute[0]);
            LOGGER.info("Building class list");
            this.callJava(Phase.CLASSES, isDebug, printer, baseDir, baseArgs, "-Xshare:off", "-XX:DumpLoadedClassList=" + classListFile, SmithyCli.class.getName(), "warmup");
            LOGGER.info("Building archive from classlist");
            this.callJava(Phase.WRAPPER, isDebug, printer, baseDir, baseArgs, "-XX:SharedClassListFile=" + classListFile, "-Xshare:dump", "-XX:SharedArchiveFile=" + jsaFile, SmithyCli.class.getName(), "warmup");
            LOGGER.info("Validating that the archive was created correctly");
            this.callJava(null, isDebug, printer, baseDir, baseArgs, "-Xshare:on", "-XX:SharedArchiveFile=" + jsaFile, SmithyCli.class.getName(), "--help");
            classListFile.toFile().delete();
            return 0;
        }
        catch (IOException e) {
            throw new CliError("Error running warmup command", 1, e);
        }
    }

    private String getOrThrowIfUndefinedProperty(String property) {
        String result = System.getProperty(property);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new CliError(result + " system property is not defined");
        }
        return result;
    }

    private void callJava(Phase phase, boolean isDebug, CliPrinter printer, Path baseDir, List<String> baseArgs, String ... args) {
        ArrayList<String> resolved = new ArrayList<String>(baseArgs);
        Collections.addAll(resolved, args);
        if (isDebug) {
            resolved.add("--debug");
        }
        if (phase != null) {
            resolved.add("--phase");
            resolved.add(phase.toString());
        }
        LOGGER.fine(() -> "Running Java command: " + resolved);
        StringBuilder builder = new StringBuilder();
        int result = IoUtils.runCommand(resolved, (Path)baseDir, (Appendable)builder, (Map)MapUtils.of());
        if (isDebug || result != 0) {
            printer.println(builder.toString().trim());
        }
        if (result != 0) {
            throw new CliError("Error warming up CLI in phase " + (Object)((Object)phase), result);
        }
    }

    private int runCodeToOptimize(Arguments arguments, Command.Env env) {
        try {
            Path tempDirWithPrefix = Files.createTempDirectory("smithy-warmup", new FileAttribute[0]);
            MavenDependencyResolver resolver = new MavenDependencyResolver(tempDirWithPrefix.toString());
            this.resolve(resolver);
            this.resolve(resolver);
            File buildFile = tempDirWithPrefix.resolve("smithy-build.json").toFile();
            try (FileWriter writer = new FileWriter(buildFile);){
                writer.write("{\n  \"version\": \"1.0\",\n  \"maven\": {\"dependencies\": [\"software.amazon.smithy:smithy-model:" + SmithyCli.getVersion() + "\"]}\n}");
            }
            SmithyBuildConfig.builder().load(buildFile.toPath()).build();
            new ValidateCommand("a", (c, e) -> resolver).execute(arguments, env);
            new BuildCommand("a", (c, e) -> resolver).execute(arguments, env);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return 0;
    }

    private void resolve(DependencyResolver resolver) {
        resolver.addRepository(MavenRepository.builder().url("https://repo.maven.apache.org/maven2").build());
        resolver.addDependency("software.amazon.smithy:smithy-model:1.26.0");
        resolver.resolve();
    }

    private static final class Config
    implements ArgumentReceiver {
        private Phase phase = Phase.WRAPPER;

        private Config() {
        }

        @Override
        public Consumer<String> testParameter(String name) {
            if (name.equals("--phase")) {
                return phase -> {
                    this.phase = Phase.valueOf(phase.toUpperCase(Locale.ENGLISH));
                };
            }
            return null;
        }
    }

    private static enum Phase {
        WRAPPER,
        CLASSES,
        DUMP;

    }
}

