/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.apache.maven.model.path;

import java.io.File;
import software.amazon.smithy.cli.shaded.apache.maven.model.path.PathTranslator;
import software.amazon.smithy.cli.shaded.apache.maven.model.profile.ProfileActivationContext;
import software.amazon.smithy.cli.shaded.codehaus.plexus.interpolation.AbstractValueSource;
import software.amazon.smithy.cli.shaded.codehaus.plexus.interpolation.InterpolationException;
import software.amazon.smithy.cli.shaded.codehaus.plexus.interpolation.MapBasedValueSource;
import software.amazon.smithy.cli.shaded.codehaus.plexus.interpolation.RegexBasedInterpolator;
import software.amazon.smithy.cli.shaded.javax.inject.Inject;
import software.amazon.smithy.cli.shaded.javax.inject.Named;
import software.amazon.smithy.cli.shaded.javax.inject.Singleton;

@Named
@Singleton
public class ProfileActivationFilePathInterpolator {
    @Inject
    private PathTranslator pathTranslator;

    public ProfileActivationFilePathInterpolator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    public String interpolate(String path, ProfileActivationContext context) throws InterpolationException {
        if (path == null) {
            return null;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final File basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return basedir.getAbsolutePath();
                    }
                    return null;
                }
            });
        } else if (path.contains("${basedir}")) {
            return null;
        }
        interpolator.addValueSource(new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getSystemProperties()));
        String absolutePath = interpolator.interpolate(path, "");
        return this.pathTranslator.alignToBaseDirectory(absolutePath, basedir);
    }
}

