/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.ClasspathCommand;
import software.amazon.smithy.cli.commands.ModelBuilder;
import software.amazon.smithy.cli.dependencies.DependencyResolver;

final class ValidateCommand
extends ClasspathCommand {
    private static final Logger LOGGER = Logger.getLogger(ValidateCommand.class.getName());

    ValidateCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        super(parentCommandName, dependencyResolverFactory);
    }

    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getSummary() {
        return "Validates Smithy models.";
    }

    @Override
    int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env, List<String> models) {
        new ModelBuilder().config(config).arguments(arguments).env(env).models(models).validationPrinter(env.stdout()).build();
        LOGGER.info("Smithy validation complete");
        return 0;
    }
}

