/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.commands.ClasspathCommand;
import software.amazon.smithy.cli.commands.ModelBuilder;
import software.amazon.smithy.cli.commands.SeverityOption;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.IoUtils;

final class SelectCommand
extends ClasspathCommand {
    private static final Logger LOGGER = Logger.getLogger(SelectCommand.class.getName());

    SelectCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        super(parentCommandName, dependencyResolverFactory);
    }

    @Override
    public String getName() {
        return "select";
    }

    @Override
    public String getSummary() {
        return "Queries a model using a selector.";
    }

    @Override
    public String getDocumentation(ColorFormatter colors) {
        return "By default, each matching shape ID is printed to stdout on a new line. Pass --vars to print out a JSON array that contains a 'shape' and 'vars' property, where the 'vars' property is a map of each variable that was captured when the shape was matched.";
    }

    @Override
    protected void configureArgumentReceivers(Arguments arguments) {
        super.configureArgumentReceivers(arguments);
        arguments.addReceiver(new Options());
        arguments.removeReceiver(SeverityOption.class);
    }

    @Override
    int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env, List<String> models) {
        Model model = new ModelBuilder().config(config).arguments(arguments).env(env).models(models).validationPrinter(env.stderr()).validationMode(Validator.Mode.DISABLE).severity(Severity.DANGER).build();
        Options options = arguments.getReceiver(Options.class);
        Selector selector = options.selector();
        OutputFormat outputFormat = OutputFormat.determineFormat(options);
        long startTime = System.nanoTime();
        outputFormat.dumpResults(selector, model, options, env.stdout());
        long endTime = System.nanoTime();
        if (LOGGER.isLoggable(Level.FINE)) {
            env.stdout().flush();
            LOGGER.fine("Select time: " + (endTime - startTime) / 1000000L + "ms");
        }
        return 0;
    }

    static enum OutputFormat {
        SHAPE_ID_LINES{

            @Override
            void dumpResults(Selector selector, Model model, Options options, CliPrinter stdout) {
                OutputFormat.sortShapeIds(selector.select(model)).forEach(stdout::println);
            }
        }
        ,
        JSON{

            @Override
            void dumpResults(Selector selector, Model model, Options options, CliPrinter stdout) {
                List result = selector.matches(model).map(match -> {
                    ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("shape", (ToNode)Node.from((String)match.getShape().getId().toString()));
                    if (!match.isEmpty()) {
                        builder.withMember("vars", (ToNode)OutputFormat.collectVars((Map)match));
                    }
                    if (!options.showTraits.isEmpty()) {
                        TreeMap values = new TreeMap();
                        for (ShapeId trait : options.showTraits) {
                            match.getShape().findTrait(trait).ifPresent(found -> values.put(Node.from((String)trait.toString()), found.toNode()));
                        }
                        builder.withMember("traits", (ToNode)Node.objectNode(values));
                    }
                    return builder.build();
                }).collect(Collectors.toList());
                stdout.println(Node.prettyPrintJson((Node)new ArrayNode(result, SourceLocation.NONE)));
            }
        };


        abstract void dumpResults(Selector var1, Model var2, Options var3, CliPrinter var4);

        static OutputFormat determineFormat(Options options) {
            return !options.vars() && options.showTraits.isEmpty() ? SHAPE_ID_LINES : JSON;
        }

        private static Stream<String> sortShapeIds(Collection<Shape> shapes) {
            return shapes.stream().map(Shape::getId).map(ShapeId::toString).sorted();
        }

        private static ObjectNode collectVars(Map<String, Set<Shape>> vars) {
            ObjectNode.Builder varBuilder = Node.objectNodeBuilder();
            for (Map.Entry<String, Set<Shape>> varEntry : vars.entrySet()) {
                ArrayNode value = (ArrayNode)OutputFormat.sortShapeIds((Collection<Shape>)varEntry.getValue()).map(Node::from).collect(ArrayNode.collect());
                varBuilder.withMember(varEntry.getKey(), (ToNode)value);
            }
            return varBuilder.build();
        }
    }

    private static final class Options
    implements ArgumentReceiver {
        private boolean vars;
        private Selector selector;
        private final List<ShapeId> showTraits = new ArrayList<ShapeId>();

        private Options() {
        }

        @Override
        public boolean testOption(String name) {
            if (name.equals("--vars")) {
                this.vars = true;
                return true;
            }
            return false;
        }

        @Override
        public Consumer<String> testParameter(String name) {
            switch (name) {
                case "--selector": {
                    return value -> {
                        this.selector = Selector.parse((String)value);
                    };
                }
                case "--show-traits": {
                    return value -> {
                        for (String trait : value.split(",", -1)) {
                            if ((trait = trait.trim()).isEmpty()) {
                                throw new CliError("--show-traits cannot contain empty trait values");
                            }
                            this.showTraits.add(ShapeId.fromOptionalNamespace((String)"smithy.api", (String)trait));
                        }
                        if (this.showTraits.isEmpty()) {
                            throw new CliError("--show-traits must contain traits");
                        }
                    };
                }
            }
            return null;
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.param("--selector", null, "SELECTOR", "The Smithy selector to execute. Reads from STDIN when not provided.");
            printer.param("--show-traits", null, "TRAITS", "Returns JSON output that includes the values of specific traits applied to matched shapes, stored in a 'traits' property. Provide a comma-separated list of trait shape IDs. Prelude traits may omit a namespace (e.g., 'required' or 'smithy.api#required').");
            printer.option("--vars", null, "Returns JSON output that includes the variables that were captured when a shape was matched, stored in a 'vars' property.");
        }

        public boolean vars() {
            return this.vars;
        }

        public Selector selector() {
            if (this.selector == null) {
                this.selector = Selector.parse((String)IoUtils.toUtf8String((InputStream)System.in));
            }
            return this.selector;
        }
    }
}

