/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.SmithyCli;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.ClasspathCommand;
import software.amazon.smithy.cli.commands.ValidateCommand;
import software.amazon.smithy.cli.dependencies.DependencyResolver;
import software.amazon.smithy.cli.dependencies.MavenDependencyResolver;

final class WarmupCommand
extends ClasspathCommand {
    private static final Logger LOGGER = Logger.getLogger(WarmupCommand.class.getName());

    WarmupCommand(String parentCommandName, DependencyResolver.Factory dependencyResolverFactory) {
        super(parentCommandName, dependencyResolverFactory);
    }

    @Override
    public String getName() {
        return "warmup";
    }

    @Override
    public String getSummary() {
        return "Creates caches for faster subsequent executions.";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    int runWithClassLoader(SmithyBuildConfig config, Arguments arguments, Command.Env env, List<String> models) {
        if (EnvironmentVariable.getByName("SMITHY_WARMUP_INTERNAL_ONLY") == null) {
            throw new UnsupportedOperationException("The warmup command is for internal use only and may be removed in the future");
        }
        LOGGER.info(() -> "Warming up Smithy CLI");
        try {
            Path tempDirWithPrefix = Files.createTempDirectory("smithy-warmup", new FileAttribute[0]);
            MavenDependencyResolver resolver = new MavenDependencyResolver(tempDirWithPrefix.toString());
            this.resolve(resolver);
            this.resolve(resolver);
            File buildFile = tempDirWithPrefix.resolve("smithy-build.json").toFile();
            try (FileWriter writer = new FileWriter(buildFile);){
                writer.write("{\n  \"version\": \"1.0\",\n  \"maven\": {\"dependencies\": [\"software.amazon.smithy:smithy-model:" + SmithyCli.getVersion() + "\"]}\n}");
            }
            SmithyBuildConfig.builder().load(buildFile.toPath()).build();
            new ValidateCommand("a", (c, e) -> resolver).execute(arguments, env);
            new BuildCommand("a", (c, e) -> resolver).execute(arguments, env);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return 0;
    }

    private void resolve(DependencyResolver resolver) {
        resolver.addRepository(MavenRepository.builder().url("https://repo.maven.apache.org/maven2").build());
        resolver.addDependency("software.amazon.smithy:smithy-model:1.26.0");
        resolver.resolve();
    }
}

