/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.ConfigOptions;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.SmithyIdlModelSerializer;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.SimpleParser;
import software.amazon.smithy.utils.StringUtils;

final class Upgrade1to2Command
extends SimpleCommand {
    private static final Logger LOGGER = Logger.getLogger(Upgrade1to2Command.class.getName());
    private static final Pattern VERSION_1 = Pattern.compile("(?m)^\\s*\\$\\s*version:\\s*\"1\\.0\"\\s*$");
    private static final Pattern VERSION_2 = Pattern.compile("(?m)^\\s*\\$\\s*version:\\s*\"2\\.0\"\\s*$");

    Upgrade1to2Command(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return Arrays.asList(new ConfigOptions(), new BuildOptions());
    }

    @Override
    public String getName() {
        return "upgrade-1-to-2";
    }

    @Override
    public String getSummary() {
        return "Upgrades Smithy IDL model files from 1.0 to 2.0 in place.";
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> models) {
        Path tempDir;
        ClassLoader classLoader = env.classLoader();
        ConfigOptions configOptions = arguments.getReceiver(ConfigOptions.class);
        SmithyBuildConfig smithyBuildConfig = configOptions.createSmithyBuildConfig();
        SmithyBuildConfig.Builder configBuilder = smithyBuildConfig.toBuilder();
        try {
            tempDir = Files.createTempDirectory("smithyUpgrade", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CliError("Unable to create temporary working directory: " + e);
        }
        configBuilder.outputDirectory(tempDir.toString());
        SmithyBuildConfig temporaryConfig = configBuilder.build();
        Model initialModel = CommandUtils.buildModel(arguments, models, env, env.stderr(), true, smithyBuildConfig);
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)classLoader).config(temporaryConfig).projectionFilter(name -> name.equals("source")).modelAssemblerSupplier(() -> {
            ModelAssembler assembler = Model.assembler();
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
            return assembler;
        }).model(initialModel);
        ResultConsumer resultConsumer = new ResultConsumer();
        smithyBuild.build((Consumer)resultConsumer, (BiConsumer)resultConsumer);
        Model finalizedModel = resultConsumer.getResult().getModel();
        for (Path modelFile : this.resolveModelFiles(finalizedModel, models)) {
            this.writeUpgradedFile(finalizedModel, modelFile);
        }
        return 0;
    }

    private List<Path> resolveModelFiles(Model model, List<String> modelFilesOrDirectories) {
        Set absoluteModelFilesOrDirectories = modelFilesOrDirectories.stream().map(path -> Paths.get(path, new String[0]).toAbsolutePath()).collect(Collectors.toSet());
        return model.shapes().filter(shape -> !Prelude.isPreludeShape((ToShapeId)shape)).filter(shape -> !shape.getSourceLocation().getFilename().startsWith("jar:")).map(shape -> Paths.get(shape.getSourceLocation().getFilename(), new String[0]).toAbsolutePath()).distinct().filter(locationPath -> {
            for (Path inputPath : absoluteModelFilesOrDirectories) {
                if (locationPath.startsWith(inputPath)) continue;
                LOGGER.finest("Skipping non-target model file: " + locationPath);
                return false;
            }
            if (!locationPath.toString().endsWith(".smithy")) {
                LOGGER.info("Skipping non-IDL model file: " + locationPath);
                return false;
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    private void writeUpgradedFile(Model completeModel, Path filePath) {
        try {
            Files.write(filePath, this.upgradeFile(completeModel, filePath).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CliError(String.format("Unable to write upgraded model file to %s: %s", filePath, e));
        }
    }

    String upgradeFile(Model completeModel, Path filePath) {
        String contents = IoUtils.readUtf8File((Path)filePath);
        if (VERSION_2.matcher(contents).find()) {
            return contents;
        }
        ShapeUpgradeVisitor visitor = new ShapeUpgradeVisitor(completeModel, contents);
        completeModel.shapes().filter(shape -> shape.getSourceLocation().getFilename().equals(filePath.toString())).sorted(Comparator.comparing(Shape::getSourceLocation).reversed()).forEach(shape -> shape.accept((ShapeVisitor)visitor));
        return this.updateVersion(visitor.getModelString());
    }

    private String updateVersion(String modelString) {
        Matcher matcher = VERSION_1.matcher(modelString);
        if (matcher.find()) {
            return matcher.replaceFirst(String.format("\\$version: \"2.0\"%n", new Object[0]));
        }
        return String.format("$version: \"2.0\"%n%n", new Object[0]) + modelString;
    }

    private static final class ResultConsumer
    implements Consumer<ProjectionResult>,
    BiConsumer<String, Throwable> {
        private Throwable error;
        private ProjectionResult result;

        private ResultConsumer() {
        }

        @Override
        public void accept(String name, Throwable throwable) {
            this.error = throwable;
        }

        @Override
        public void accept(ProjectionResult projectionResult) {
            this.result = projectionResult;
        }

        ProjectionResult getResult() {
            if (this.error != null) {
                throw new RuntimeException(this.error);
            }
            return this.result;
        }
    }

    private static class ShapeUpgradeVisitor
    extends ShapeVisitor.Default<Void> {
        private final Model completeModel;
        private final ModelWriter writer;

        ShapeUpgradeVisitor(Model completeModel, String modelString) {
            this.completeModel = completeModel;
            this.writer = new ModelWriter(modelString);
        }

        String getModelString() {
            return this.writer.flush();
        }

        protected Void getDefault(Shape shape) {
            if (shape.hasTrait(BoxTrait.class)) {
                this.writer.eraseTrait(shape, shape.expectTrait(BoxTrait.class));
            } else if (this.hasSyntheticDefault(shape)) {
                this.addDefault(shape, shape.getType());
            }
            shape.members().stream().sorted(Comparator.comparing(Shape::getSourceLocation).reversed()).forEach(this::handleMemberShape);
            return null;
        }

        private void handleMemberShape(MemberShape shape) {
            if (this.hasSyntheticDefault((Shape)shape)) {
                this.addDefault((Shape)shape, this.completeModel.expectShape(shape.getTarget()).getType());
            }
            if (shape.hasTrait(BoxTrait.class)) {
                this.writer.eraseTrait((Shape)shape, shape.expectTrait(BoxTrait.class));
            }
        }

        private boolean hasSyntheticDefault(Shape shape) {
            Optional<SourceLocation> defaultLocation = shape.getTrait(DefaultTrait.class).map(FromSourceLocation::getSourceLocation);
            return defaultLocation.filter(location -> shape.getSourceLocation().equals(location)).isPresent();
        }

        private void addDefault(Shape shape, ShapeType targetType) {
            SourceLocation memberLocation = shape.getSourceLocation();
            String padding = "";
            if (memberLocation.getColumn() > 1) {
                padding = StringUtils.repeat((char)' ', (int)(memberLocation.getColumn() - 1));
            }
            String defaultValue = "";
            if (shape.hasTrait(BoxTrait.class)) {
                defaultValue = "null";
            } else {
                switch (targetType) {
                    case BOOLEAN: {
                        defaultValue = "false";
                        break;
                    }
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        defaultValue = "0";
                        break;
                    }
                    case BLOB: 
                    case STRING: {
                        defaultValue = "\"\"";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected default: " + targetType);
                    }
                }
            }
            this.writer.insertLine(shape.getSourceLocation().getLine(), padding + "@default(" + defaultValue + ")");
        }

        public Void memberShape(MemberShape shape) {
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (!shape.hasTrait(EnumTrait.class)) {
                return null;
            }
            EnumTrait enumTrait = (EnumTrait)shape.expectTrait(EnumTrait.class);
            if (!((EnumDefinition)enumTrait.getValues().iterator().next()).getName().isPresent()) {
                return null;
            }
            this.writer.insertLine(shape.getSourceLocation().getLine() + 1, this.serializeEnum(shape));
            this.writer.eraseLine(shape.getSourceLocation().getLine());
            this.writer.eraseTrait((Shape)shape, (Trait)enumTrait);
            return null;
        }

        private String serializeEnum(StringShape shape) {
            StringShape stripped = ((StringShape.Builder)((StringShape.Builder)shape.toBuilder().clearTraits()).addTrait(shape.expectTrait(EnumTrait.class))).build();
            Model model = (Model)Model.assembler().addShapes(new Shape[]{stripped}).assemble().unwrap();
            model = ModelTransformer.create().changeStringEnumsToEnumShapes(model);
            Map files = SmithyIdlModelSerializer.builder().build().serialize(model);
            String serialized = (String)files.values().iterator().next();
            ArrayList<String> lines = new ArrayList<String>();
            boolean foundEnum = false;
            for (String line : serialized.split("\\r?\\n")) {
                if (foundEnum) {
                    lines.add(line);
                    continue;
                }
                if (!line.startsWith("enum")) continue;
                lines.add(line);
                foundEnum = true;
            }
            return String.join((CharSequence)System.lineSeparator(), lines);
        }
    }

    private static class ModelWriter {
        private String contents;

        ModelWriter(String contents) {
            this.contents = contents;
        }

        public String flush() {
            if (!this.contents.endsWith(System.lineSeparator())) {
                this.contents = this.contents + System.lineSeparator();
            }
            return this.contents;
        }

        private void insertLine(int lineNumber, String line) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.contents.split("\\r?\\n")));
            lines.add(lineNumber - 1, line);
            this.contents = String.join((CharSequence)System.lineSeparator(), lines);
        }

        private void eraseLine(int lineNumber) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(this.contents.split("\\r?\\n")));
            lines.remove(lineNumber - 1);
            this.contents = String.join((CharSequence)System.lineSeparator(), lines);
        }

        private void eraseTrait(Shape shape, Trait trait) {
            if (trait.getSourceLocation() != SourceLocation.NONE) {
                SourceLocation to = this.findLocationAfterTrait(shape, trait.getClass());
                this.erase(trait.getSourceLocation(), to);
            }
        }

        private SourceLocation findLocationAfterTrait(Shape shape, Class<? extends Trait> target) {
            boolean haveSeenTarget = false;
            ArrayList traits = new ArrayList(shape.getIntroducedTraits().values());
            traits.sort(Comparator.comparing(FromSourceLocation::getSourceLocation));
            for (Trait trait : traits) {
                if (target.isInstance(trait)) {
                    haveSeenTarget = true;
                    continue;
                }
                if (!haveSeenTarget || trait.getSourceLocation().equals((Object)SourceLocation.NONE)) continue;
                return trait.getSourceLocation();
            }
            return shape.getSourceLocation();
        }

        private void erase(SourceLocation from, SourceLocation to) {
            IdlAwareSimpleParser parser = new IdlAwareSimpleParser(this.contents);
            parser.rewind(from);
            int fromPosition = parser.position();
            parser.rewind(to);
            int toPosition = parser.position();
            this.contents = this.contents.substring(0, fromPosition) + this.contents.substring(toPosition);
        }

        private void replace(int from, int to, String with) {
            this.contents = this.contents.substring(0, from) + with + this.contents.substring(to);
        }
    }

    private static class IdlAwareSimpleParser
    extends SimpleParser {
        IdlAwareSimpleParser(String expression) {
            super(expression);
        }

        public void rewind(SourceLocation location) {
            this.rewind(0, 1, 1);
            while (!(this.eof() || this.line() == location.getLine() && this.column() == location.getColumn())) {
                this.skip();
            }
            if (this.eof()) {
                throw this.syntax("Expected a source location, but was EOF");
            }
        }

        public void ws() {
            block4: while (!this.eof()) {
                switch (this.peek()) {
                    case '/': {
                        if (this.peek(1) == '/') {
                            this.consumeRemainingCharactersOnLine();
                            continue block4;
                        }
                        return;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': {
                        this.skip();
                        continue block4;
                    }
                }
                return;
            }
        }
    }
}

