/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ValidateCommand
implements Command {
    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getSummary() {
        return "Validates Smithy models";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().option("--allow-unknown-traits", "Ignores unknown traits when validating models").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        List<String> models = arguments.positionalArguments();
        Colors.BRIGHT_WHITE.out(String.format("Validating Smithy model sources: %s", models));
        CommandUtils.buildModel(arguments, classLoader, SetUtils.of());
        Colors.BRIGHT_BOLD_GREEN.out("Smithy validation complete");
    }
}

