/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Collections;
import java.util.Comparator;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;

final class Validator {
    private Validator() {
    }

    static void validate(ValidatedResult<Model> result) {
        Validator.validate(result, false);
    }

    static void validate(ValidatedResult<Model> result, boolean quiet) {
        result.getValidationEvents().stream().filter(event -> event.getSeverity() != Severity.SUPPRESSED).sorted(Comparator.comparing(ValidationEvent::toString)).forEach(event -> {
            if (event.getSeverity() == Severity.WARNING) {
                Colors.out(Colors.YELLOW, event.toString());
            } else if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                Colors.out(Colors.RED, event.toString());
            } else {
                System.out.println(event);
            }
        });
        long errors = result.getValidationEvents(Severity.ERROR).size();
        long dangers = result.getValidationEvents(Severity.DANGER).size();
        if (!quiet) {
            String line = String.format("Validation result: %s ERROR(s), %d DANGER(s), %d WARNING(s), %d NOTE(s)", errors, dangers, result.getValidationEvents(Severity.WARNING).size(), result.getValidationEvents(Severity.NOTE).size());
            System.out.println(String.join((CharSequence)"", Collections.nCopies(line.length(), "-")));
            System.out.println(line);
            result.getResult().ifPresent(model -> System.out.println(String.format("Validated %d shapes in model", model.shapes().count())));
        }
        if (errors + dangers > 0L) {
            throw new CliError(String.format("The model is invalid: %s ERROR(s), %d DANGER(s)", errors, dangers));
        }
    }
}

