/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

public enum Colors {
    BLACK(30),
    RED(31),
    BOLD_RED(31, true),
    GREEN(32),
    BOLD_GREEN(32, true),
    YELLOW(33),
    BLUE(34),
    MAGENTA(35),
    CYAN(36),
    WHITE(37),
    BRIGHT_BLACK(90),
    BRIGHT_RED(91),
    BRIGHT_BOLD_RED(91, true),
    BRIGHT_GREEN(92),
    BRIGHT_BOLD_GREEN(92, true),
    BRIGHT_YELLOW(93),
    BRIGHT_BOLD_YELLOW(93, true),
    BRIGHT_BLUE(94),
    BRIGHT_MAGENTA(95),
    BRIGHT_CYAN(96),
    BRIGHT_WHITE(97);

    private static boolean useAnsiColors;
    private int escape;
    private boolean bold;

    private Colors(int escape) {
        this(escape, false);
    }

    private Colors(int escape, boolean bold) {
        this.escape = escape;
        this.bold = bold;
    }

    public static void setUseAnsiColors(boolean useAnsiColors) {
        Colors.useAnsiColors = useAnsiColors;
    }

    private static boolean useAnsi() {
        return System.console() != null && System.getenv().get("TERM") != null;
    }

    public static void out(Colors color, String message) {
        if (useAnsiColors) {
            System.out.println(Colors.format(color, message));
        } else {
            System.out.println(message);
        }
    }

    public static void err(Colors color, String message) {
        if (useAnsiColors) {
            System.err.println(Colors.format(color, message));
        } else {
            System.err.println(message);
        }
    }

    private static String format(Colors color, String message) {
        String colored = String.format("\u001b[%dm%s\u001b[0m", color.escape, message);
        return color.bold ? String.format("\u001b[1m%s\u001b[0m", colored) : colored;
    }

    static {
        useAnsiColors = Colors.useAnsi();
    }
}

