/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.logging.Logger;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.model.loader.ModelAssembler;

final class CommandUtils {
    private static final Logger LOGGER = Logger.getLogger(CommandUtils.class.getName());

    private CommandUtils() {
    }

    static void handleUnknownTraitsOption(Arguments arguments, ModelAssembler assembler) {
        if (arguments.has("--allow-unknown-traits")) {
            LOGGER.fine("Ignoring unknown traits");
            assembler.putProperty("assembler.allowUnknownTraits", (Object)true);
        }
    }

    static void handleModelDiscovery(Arguments arguments, ModelAssembler assembler, ClassLoader baseLoader) {
        if (arguments.has("--discover-classpath")) {
            CommandUtils.discoverModelsWithClasspath(arguments, assembler);
        } else if (arguments.has("--discover")) {
            assembler.discoverModels(baseLoader);
        }
    }

    private static void discoverModelsWithClasspath(Arguments arguments, ModelAssembler assembler) {
        String rawClasspath = arguments.parameter("--discover-classpath");
        LOGGER.finer("Discovering models with classpath: " + rawClasspath);
        String[] classpath = rawClasspath.split(":");
        URL[] urls = new URL[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            try {
                urls[i] = Paths.get(classpath[i], new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new CliError("Error parsing model discovery URL: " + classpath[i]);
            }
        }
        AccessController.doPrivileged(() -> {
            URLClassLoader urlClassLoader = new URLClassLoader(urls);
            assembler.discoverModels((ClassLoader)urlClassLoader);
            return null;
        });
    }
}

