/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.build.plugins.BuildInfo;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;

public final class BuildInfoPlugin
implements SmithyBuildPlugin {
    private static final String NAME = "build-info";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresValidModel() {
        return false;
    }

    @Override
    public void execute(PluginContext context) {
        if (context.getOriginalModel().isPresent() && context.getProjection().isPresent()) {
            context.getFileManifest().writeJson("smithy-build-info.json", BuildInfoPlugin.serializeBuildInfo(context));
        }
    }

    private static Node serializeBuildInfo(PluginContext context) {
        BuildInfo info = new BuildInfo();
        info.setProjectionName(context.getProjectionName());
        info.setProjection(context.getProjection().orElse(null));
        info.setValidationEvents(context.getEvents());
        info.setTraitNames(BuildInfoPlugin.findTraitNames(context.getModel()));
        info.setTraitDefNames(context.getModel().getShapesWithTrait(TraitDefinition.class).stream().map(Shape::getId).sorted().collect(Collectors.toList()));
        info.setServiceShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), ServiceShape.class));
        info.setOperationShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), OperationShape.class));
        info.setResourceShapeIds(BuildInfoPlugin.findShapeIds(context.getModel(), ResourceShape.class));
        info.setMetadata(context.getModel().getMetadata());
        NodeMapper mapper = new NodeMapper();
        return mapper.serialize((Object)info);
    }

    private static List<ShapeId> findTraitNames(Model model) {
        return model.shapes().flatMap(shape -> shape.getAllTraits().keySet().stream()).distinct().sorted().collect(Collectors.toList());
    }

    private static <T extends Shape> List<ShapeId> findShapeIds(Model model, Class<T> clazz) {
        return model.shapes(clazz).map(Shape::getId).sorted().collect(Collectors.toList());
    }
}

