/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TransformContext
implements ToSmithyBuilder<TransformContext> {
    private final ObjectNode settings;
    private final Model model;
    private final Model originalModel;
    private final Set<Path> sources;
    private final String projectionName;
    private final ModelTransformer transformer;
    private final List<ValidationEvent> originalModelValidationEvents;

    private TransformContext(Builder builder) {
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.transformer = builder.transformer != null ? builder.transformer : ModelTransformer.create();
        this.settings = builder.settings;
        this.originalModel = builder.originalModel;
        this.projectionName = builder.projectionName;
        this.sources = (Set)builder.sources.copy();
        this.originalModelValidationEvents = (List)builder.originalModelValidationEvents.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TransformContext.builder().settings(this.settings).model(this.model).originalModel(this.originalModel).sources(this.sources).projectionName(this.projectionName).transformer(this.transformer).originalModelValidationEvents(this.originalModelValidationEvents);
    }

    public ObjectNode getSettings() {
        return this.settings;
    }

    public Model getModel() {
        return this.model;
    }

    public Optional<Model> getOriginalModel() {
        return Optional.ofNullable(this.originalModel);
    }

    public Set<Path> getSources() {
        return this.sources;
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public ModelTransformer getTransformer() {
        return this.transformer;
    }

    public List<ValidationEvent> getOriginalModelValidationEvents() {
        return this.originalModelValidationEvents;
    }

    public static final class Builder
    implements SmithyBuilder<TransformContext> {
        private ObjectNode settings = Node.objectNode();
        private Model model;
        private Model originalModel;
        private final BuilderRef<Set<Path>> sources = BuilderRef.forOrderedSet();
        private String projectionName = "source";
        private ModelTransformer transformer;
        private final BuilderRef<List<ValidationEvent>> originalModelValidationEvents = BuilderRef.forList();

        private Builder() {
        }

        public TransformContext build() {
            return new TransformContext(this);
        }

        public Builder settings(ObjectNode settings) {
            this.settings = Objects.requireNonNull(settings);
            return this;
        }

        public Builder model(Model model) {
            this.model = Objects.requireNonNull(model);
            return this;
        }

        public Builder originalModel(Model originalModel) {
            this.originalModel = originalModel;
            return this;
        }

        public Builder sources(Set<Path> sources) {
            this.sources.clear();
            ((Set)this.sources.get()).addAll(sources);
            return this;
        }

        public Builder projectionName(String projectionName) {
            this.projectionName = Objects.requireNonNull(projectionName);
            return this;
        }

        public Builder transformer(ModelTransformer transformer) {
            this.transformer = transformer;
            return this;
        }

        public Builder originalModelValidationEvents(List<ValidationEvent> originalModelValidationEvents) {
            this.originalModelValidationEvents.clear();
            ((List)this.originalModelValidationEvents.get()).addAll(originalModelValidationEvents);
            return this;
        }
    }
}

