/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class RemoveUnusedShapes
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "removeUnusedShapes";
    }

    @Override
    public String getBackwardCompatibleNameMapping() {
        return "exportTagged";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        int currentShapeCount;
        Predicate<Shape> keepShapesByTag = shape -> config.getExportTagged().stream().noneMatch(arg_0 -> ((Shape)shape).hasTag(arg_0));
        Predicate<Shape> keepTraitDefsByTag = trait -> config.getExportTagged().stream().noneMatch(arg_0 -> ((Shape)trait).hasTag(arg_0));
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        do {
            currentShapeCount = model.toSet().size();
            model = transformer.removeUnreferencedShapes(model, keepShapesByTag);
        } while (currentShapeCount != (model = transformer.removeUnreferencedTraitDefinitions(model, keepTraitDefsByTag)).toSet().size());
        return model;
    }

    public static final class Config {
        private Set<String> exportTagged = Collections.emptySet();

        public void setExportTagged(Set<String> exportByTags) {
            this.exportTagged = exportByTags;
        }

        public Set<String> getExportTagged() {
            return this.exportTagged;
        }
    }
}

