/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.SmithyBuildException;

final class DefaultFileManifest
implements FileManifest {
    private final Set<Path> files = new ConcurrentSkipListSet<Path>(Comparator.comparing(Path::toString));
    private final Path baseDir;

    DefaultFileManifest(Path baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Set<Path> getFiles() {
        return new LinkedHashSet<Path>(this.files);
    }

    @Override
    public Path addFile(Path path) {
        Path parent;
        Objects.requireNonNull(path);
        if (!path.startsWith(this.baseDir) || !path.isAbsolute()) {
            path = this.resolvePath(path);
        }
        if ((parent = path.getParent()) != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SmithyBuildException(String.format("Error create directory `%s`: %s", parent, e.getMessage()));
            }
        }
        this.files.add(path);
        return path;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path writeFile(Path path, Reader fileContentsReader) {
        path = this.addFile(path);
        try (BufferedReader bufferedReader = new BufferedReader(fileContentsReader);){
            Path path2;
            block14: {
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    int len;
                    char[] buffer = new char[4096];
                    while ((len = bufferedReader.read(buffer)) != -1) {
                        writer.write(buffer, 0, len);
                    }
                    path2 = path;
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return path2;
        }
        catch (IOException e) {
            throw new SmithyBuildException("Unable to write contents of file `" + path + "`: " + e.getMessage(), e);
        }
    }

    @Override
    public Path writeFile(Path path, InputStream fileContentsInputStream) {
        path = this.addFile(path);
        try {
            Files.copy(fileContentsInputStream, path, StandardCopyOption.REPLACE_EXISTING);
            return path;
        }
        catch (IOException e) {
            throw new SmithyBuildException("Unable to write contents of file `" + path + "`: " + e.getMessage(), e);
        }
    }
}

