/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.smithy.build.DefaultFileManifest;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.model.node.Node;

public interface FileManifest {
    public static FileManifest create(Path basePath) {
        return new DefaultFileManifest(basePath);
    }

    public Path getBaseDir();

    public Set<Path> getFiles();

    public Path addFile(Path var1);

    default public void addAllFiles(FileManifest manifest) {
        manifest.getFiles().forEach(this::addFile);
    }

    default public Path resolvePath(Path path) {
        Path result = this.getBaseDir().resolve(path);
        if (!result.startsWith(this.getBaseDir())) {
            throw new SmithyBuildException(String.format("Paths must be relative to the base directory, %s, but found %s", this.getBaseDir(), result));
        }
        return result;
    }

    public Path writeFile(Path var1, Reader var2);

    public Path writeFile(Path var1, InputStream var2);

    default public Path writeFile(Path path, Class klass, String resource) {
        Path path2;
        block8: {
            InputStream inputStream = klass.getResourceAsStream(resource);
            try {
                path2 = this.writeFile(path, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SmithyBuildException("Error loading class resource from " + resource + ": " + e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return path2;
    }

    default public Path writeFile(String path, Class klass, String resource) {
        return this.writeFile(Paths.get(path, new String[0]), klass, resource);
    }

    default public Path writeFile(Path path, String fileContentsText) {
        return this.writeFile(path, (Reader)new StringReader(fileContentsText));
    }

    default public Path writeFile(String path, String fileContentsText) {
        return this.writeFile(Paths.get(path, new String[0]), fileContentsText);
    }

    default public Path writeFile(String path, Reader fileContentsReader) {
        return this.writeFile(Paths.get(path, new String[0]), fileContentsReader);
    }

    default public Path writeFile(String path, InputStream fileContentsInputStream) {
        return this.writeFile(Paths.get(path, new String[0]), fileContentsInputStream);
    }

    default public Path writeJson(Path path, Node node) {
        return this.writeUsing(path, writer -> Node.prettyPrintJsonToWriter((Node)node, (Writer)writer));
    }

    default public Path writeJson(String path, Node node) {
        return this.writeJson(Paths.get(path, new String[0]), node);
    }

    default public Path writeUsing(Path path, Consumer<Writer> consumer) {
        Path resolved = this.addFile(path);
        try (BufferedWriter writer = Files.newBufferedWriter(resolved, new OpenOption[0]);){
            consumer.accept(writer);
            ((Writer)writer).write(10);
        }
        catch (IOException e) {
            throw new SmithyBuildException("Unable to create a write to file `" + resolved + "`: " + e.getMessage(), e);
        }
        return resolved;
    }

    default public boolean hasFile(Path file) {
        return this.getFiles().contains(this.resolvePath(file));
    }

    default public boolean hasFile(String file) {
        return this.hasFile(Paths.get(file, new String[0]));
    }

    default public List<Path> getFilesIn(Path path) {
        Path resolved = this.resolvePath(path);
        return this.getFiles().stream().filter(file -> file.startsWith(resolved)).collect(Collectors.toList());
    }

    default public List<Path> getFilesIn(String path) {
        return this.getFilesIn(Paths.get(path, new String[0]));
    }
}

