/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.SmithyBuildException;

public final class MockManifest
implements FileManifest {
    private final Path baseDir;
    private final StoreMode storeMode;
    private final Map<Path, byte[]> files = new ConcurrentSkipListMap<Path, byte[]>(Comparator.comparing(Path::toString));

    public MockManifest(Path baseDir, StoreMode storeMode) {
        this.baseDir = baseDir;
        this.storeMode = storeMode;
    }

    public MockManifest(Path baseDir) {
        this(baseDir, StoreMode.IN_MEMORY);
    }

    public MockManifest() {
        this(Paths.get("/", new String[0]));
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public Set<Path> getFiles() {
        return new LinkedHashSet<Path>(this.files.keySet());
    }

    @Override
    public Path addFile(Path path) {
        if (!path.startsWith(this.baseDir) || !path.isAbsolute()) {
            path = this.resolvePath(path);
        }
        this.files.put(path, new byte[0]);
        return path;
    }

    @Override
    public Path writeFile(Path path, Reader fileContentsReader) {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int numCharsRead;
            while ((numCharsRead = fileContentsReader.read(buffer, 0, buffer.length)) != -1) {
                builder.append(buffer, 0, numCharsRead);
            }
        }
        catch (IOException e) {
            throw new SmithyBuildException(e);
        }
        return this.storeFile(path, builder.toString().getBytes(Charset.forName("UTF-8")));
    }

    private Path storeFile(Path path, byte[] bytes) {
        path = this.resolvePath(path);
        if (this.storeMode == StoreMode.IN_MEMORY) {
            this.files.put(path, bytes);
        } else {
            this.files.put(path, new byte[0]);
        }
        return path;
    }

    @Override
    public Path writeFile(Path path, InputStream fileContentsInputStream) {
        try {
            int numCharsRead;
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((numCharsRead = fileContentsInputStream.read(buffer, 0, buffer.length)) != -1) {
                byteArrayStream.write(buffer, 0, numCharsRead);
            }
            return this.storeFile(path, byteArrayStream.toByteArray());
        }
        catch (IOException e) {
            throw new SmithyBuildException("Unable to write contents of file `" + path + "`: " + e.getMessage(), e);
        }
    }

    @Override
    public void writeUsing(Path path, Consumer<Writer> consumer) {
        StringWriter writer = new StringWriter();
        consumer.accept(writer);
        this.writeFile(path, ((Object)writer).toString());
    }

    public Optional<String> getFileString(Path file) {
        return this.getFileBytes(file).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    public Optional<String> getFileString(String file) {
        return this.getFileString(Paths.get(file, new String[0]));
    }

    public String expectFileString(Path file) {
        return this.getFileString(file).orElseThrow(() -> new InvalidPathException(file.toString(), file + " not found"));
    }

    public String expectFileString(String file) {
        return this.expectFileString(Paths.get(file, new String[0]));
    }

    public Optional<byte[]> getFileBytes(Path file) {
        return Optional.ofNullable(this.files.get(this.resolvePath(file)));
    }

    public Optional<byte[]> getFileBytes(String file) {
        return this.getFileBytes(Paths.get(file, new String[0]));
    }

    public byte[] expectFileBytes(Path file) {
        return this.getFileBytes(file).orElseThrow(() -> new InvalidPathException(file.toString(), file + " not found"));
    }

    public byte[] expectFileBytes(String file) {
        return this.expectFileBytes(Paths.get(file, new String[0]));
    }

    public static enum StoreMode {
        IN_MEMORY,
        PATH_ONLY;

    }
}

