/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MavenRepository
implements ToSmithyBuilder<MavenRepository> {
    private final String url;
    private final String httpCredentials;
    private final String id;
    private final String proxyHost;
    private final String proxyCredentials;

    public MavenRepository(Builder builder) {
        this.url = (String)SmithyBuilder.requiredState((String)"url", (Object)builder.url);
        this.httpCredentials = builder.httpCredentials;
        this.id = builder.id;
        this.proxyHost = builder.proxyHost;
        this.proxyCredentials = builder.proxyCredentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MavenRepository fromNode(Node node) {
        Builder builder = MavenRepository.builder();
        node.expectObjectNode().warnIfAdditionalProperties(Arrays.asList("url", "httpCredentials", "id", "proxyHost", "proxyCredentials")).expectStringMember("url", builder::url).getStringMember("httpCredentials", builder::httpCredentials).getStringMember("id", builder::id).getStringMember("proxyHost", builder::proxyHost).getStringMember("proxyCredentials", builder::proxyCredentials);
        return builder.build();
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<String> getHttpCredentials() {
        return Optional.ofNullable(this.httpCredentials);
    }

    public Optional<String> getProxyCredentials() {
        return Optional.ofNullable(this.proxyCredentials);
    }

    public Optional<String> getProxyHost() {
        return Optional.ofNullable(this.proxyHost);
    }

    public Builder toBuilder() {
        return MavenRepository.builder().id(this.id).url(this.url).httpCredentials(this.httpCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.httpCredentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenRepository)) {
            return false;
        }
        MavenRepository mavenRepo = (MavenRepository)o;
        return Objects.equals(this.id, mavenRepo.id) && Objects.equals(this.url, mavenRepo.url) && Objects.equals(this.httpCredentials, mavenRepo.httpCredentials);
    }

    public static final class Builder
    implements SmithyBuilder<MavenRepository> {
        private String url;
        private String httpCredentials;
        private String id;
        private String proxyHost;
        private String proxyCredentials;

        private Builder() {
        }

        public MavenRepository build() {
            return new MavenRepository(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyCredentials(String proxyCredentials) {
            this.proxyCredentials = proxyCredentials;
            this.validateColonSeparatedValue(proxyCredentials, "Invalid proxyCredentials: expected in the format of user:pass");
            return this;
        }

        public Builder httpCredentials(String httpCredentials) {
            this.httpCredentials = httpCredentials;
            this.validateColonSeparatedValue(httpCredentials, "Invalid httpCredentials: expected in the format of user:pass");
            return this;
        }

        private void validateColonSeparatedValue(String value, String errorMessage) {
            int position;
            if (value != null && ((position = value.indexOf(58)) < 1 || position == value.length() - 1)) {
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }
}

