/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.util.ArrayList;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import software.amazon.smithy.build.PluginContext;

public interface SmithyBuildPlugin {
    public String getName();

    default public boolean requiresValidModel() {
        return true;
    }

    default public boolean isSerial() {
        return false;
    }

    public void execute(PluginContext var1);

    public static Function<String, Optional<SmithyBuildPlugin>> createServiceFactory(Iterable<SmithyBuildPlugin> plugins) {
        ArrayList pluginList = new ArrayList();
        plugins.forEach(pluginList::add);
        return name -> pluginList.stream().filter(plugin -> plugin.getName().equals(name)).findFirst();
    }

    public static Function<String, Optional<SmithyBuildPlugin>> createServiceFactory() {
        return SmithyBuildPlugin.createServiceFactory(ServiceLoader.load(SmithyBuildPlugin.class));
    }

    public static Function<String, Optional<SmithyBuildPlugin>> createServiceFactory(ClassLoader classLoader) {
        return SmithyBuildPlugin.createServiceFactory(ServiceLoader.load(SmithyBuildPlugin.class, classLoader));
    }
}

