/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.Pair;

final class TraitRemovalUtils {
    private TraitRemovalUtils() {
    }

    static Pair<Set<ShapeId>, Set<String>> parseTraits(Set<String> ids) {
        HashSet<ShapeId> traitNames = new HashSet<ShapeId>();
        HashSet<String> traitNamespaces = new HashSet<String>();
        for (String arg : ids) {
            if (arg.endsWith("#")) {
                traitNamespaces.add(arg.substring(0, arg.length() - 1));
                continue;
            }
            traitNames.add(ShapeId.from((String)Trait.makeAbsoluteName((String)arg)));
        }
        return Pair.of(traitNames, traitNamespaces);
    }

    static boolean matchesTraitDefinition(Shape traitShape, Set<ShapeId> traitNames, Set<String> traitNamespaces) {
        return traitNames.contains(traitShape.getId()) || traitNamespaces.contains(traitShape.getId().getNamespace());
    }
}

