/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.utils.ListUtils;

public final class Apply
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "apply";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "projections";
    }

    @Override
    public Model transform(TransformContext context) {
        return context.getModel();
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        throw new UnsupportedOperationException("transform(TransformContext) should be called directly.");
    }

    @Override
    protected Optional<BiFunction<TransformContext, Config, List<String>>> getAdditionalProjectionsFunction() {
        return Optional.of((context, config) -> ListUtils.copyOf(config.getProjections()));
    }

    public static final class Config {
        private List<String> projections;

        public List<String> getProjections() {
            return this.projections;
        }

        public void setProjections(List<String> projections) {
            this.projections = projections;
        }
    }
}

